/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.render.FluxStorageRenderType;
import sonar.fluxnetworks.common.tileentity.TileFluxStorage;

public class FluxStorageTileRenderer
extends TileEntityRenderer<TileFluxStorage> {
    private static final float START_X = 0.125f;
    private static final float START_Y = 0.125f;
    private static final float OFFSET_Z = 0.0625f;
    private static final float WIDTH = 0.75f;
    private static final float HEIGHT = 0.8125f;
    private static final float ALPHA = 0.5882353f;
    private static final int FULL_LIGHT = 0xF000F0;

    public FluxStorageTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(@Nonnull TileFluxStorage tile, float partialTicks, @Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int color = tile.brColor;
        float r = ScreenUtils.getRed(color);
        float g = ScreenUtils.getGreen(color);
        float b = ScreenUtils.getBlue(color);
        FluxStorageTileRenderer.render(matrixStackIn, bufferIn.getBuffer(FluxStorageRenderType.getType()), r, g, b, combinedOverlayIn, tile.getTransferBuffer(), tile.getMaxTransferLimit());
    }

    static void render(MatrixStack matrix, IVertexBuilder builder, float r, float g, float b, int overlay, long energy, long capacity) {
        if (energy <= 0L || capacity <= 0L) {
            return;
        }
        float fillPercentage = (float)Math.min((double)energy / (double)capacity, 1.0);
        float renderHeight = 0.8125f * fillPercentage;
        FluxStorageTileRenderer.renderSide(matrix, builder, Direction.NORTH, 0.125f, 0.125f, 0.0625f, 0.75f, renderHeight, r, g, b, overlay, fillPercentage);
        FluxStorageTileRenderer.renderSide(matrix, builder, Direction.SOUTH, 0.125f, 0.125f, 0.0625f, 0.75f, renderHeight, r, g, b, overlay, fillPercentage);
        FluxStorageTileRenderer.renderSide(matrix, builder, Direction.EAST, 0.125f, 0.125f, 0.0625f, 0.75f, renderHeight, r, g, b, overlay, fillPercentage);
        FluxStorageTileRenderer.renderSide(matrix, builder, Direction.WEST, 0.125f, 0.125f, 0.0625f, 0.75f, renderHeight, r, g, b, overlay, fillPercentage);
        if (fillPercentage < 1.0f) {
            FluxStorageTileRenderer.renderSide(matrix, builder, Direction.DOWN, 0.0625f, 0.0625f, 0.875f - renderHeight, 0.875f, 0.875f, r, g, b, overlay, fillPercentage);
        }
    }

    private static void renderSide(@Nonnull MatrixStack matrix, @Nonnull IVertexBuilder builder, @Nonnull Direction dir, float x, float y, float z, float width, float height, float r, float g, float b, int overlay, float maxV) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227863_a_(dir.func_229384_a_());
        matrix.func_227863_a_(new Quaternion(-1.5707964f, 0.0f, 0.0f, false));
        matrix.func_227861_a_(-0.5, -0.5, -0.5);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Matrix3f normal = matrix.func_227866_c_().func_227872_b_();
        builder.func_227888_a_(matrix4f, x, y + height, z).func_227885_a_(r, g, b, 0.5882353f).func_225583_a_(0.0f, maxV).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 0.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, x + width, y + height, z).func_227885_a_(r, g, b, 0.5882353f).func_225583_a_(1.0f, maxV).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 0.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, x + width, y, z).func_227885_a_(r, g, b, 0.5882353f).func_225583_a_(1.0f, 0.0f).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 0.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, x, y, z).func_227885_a_(r, g, b, 0.5882353f).func_225583_a_(0.0f, 0.0f).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 0.0f, 0.0f, 0.0f).func_181675_d();
        matrix.func_227865_b_();
    }
}

