/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.misc;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.LazyOptional;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.network.FluxDeviceType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public class FluxUtils {
    private static final double[] COMPACT_SCALE = new double[]{0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15, 1.0E-18};

    private FluxUtils() {
    }

    @Nonnull
    public static <E extends Enum<?>> E incrementEnum(@Nonnull E val, @Nonnull E[] values) {
        int next = val.ordinal() + 1;
        if (next < values.length) {
            return values[next];
        }
        return values[0];
    }

    @Nullable
    public static Direction getBlockDirection(BlockPos pos, BlockPos other) {
        for (Direction face : Direction.values()) {
            if (!pos.func_177972_a(face).equals((Object)other)) continue;
            return face;
        }
        return null;
    }

    @Nonnull
    public static String getTransferInfo(@Nonnull IFluxDevice flux, EnergyType energyType) {
        FluxDeviceType type = flux.getDeviceType();
        long change = flux.getTransferChange();
        if (type.isPlug()) {
            if (change == 0L) {
                return FluxTranslate.INPUT.t() + ": " + TextFormatting.GOLD + "0 " + energyType.getUsageSuffix();
            }
            return FluxTranslate.INPUT.t() + ": " + TextFormatting.GREEN + "+" + EnergyType.usage(change);
        }
        if (type.isPoint() || type.isController()) {
            if (change == 0L) {
                return FluxTranslate.OUTPUT.t() + ": " + TextFormatting.GOLD + "0 " + energyType.getUsageSuffix();
            }
            return FluxTranslate.OUTPUT.t() + ": " + TextFormatting.RED + EnergyType.usage(change);
        }
        if (type.isStorage()) {
            if (change == 0L) {
                return FluxTranslate.CHANGE.t() + ": " + TextFormatting.GOLD + "0 " + energyType.getUsageSuffix();
            }
            if (change > 0L) {
                return FluxTranslate.CHANGE.t() + ": " + TextFormatting.GREEN + "+" + EnergyType.usage(change);
            }
            return FluxTranslate.CHANGE.t() + ": " + TextFormatting.RED + EnergyType.usage(change);
        }
        return "";
    }

    @Nonnull
    public static GlobalPos getGlobalPos(@Nonnull TileFluxDevice tile) {
        return GlobalPos.func_239648_a_((RegistryKey)tile.getFluxWorld().func_234923_W_(), (BlockPos)tile.func_174877_v());
    }

    public static void writeGlobalPos(@Nonnull CompoundNBT nbt, @Nonnull GlobalPos pos) {
        BlockPos p = pos.func_218180_b();
        nbt.func_74768_a("x", p.func_177958_n());
        nbt.func_74768_a("y", p.func_177956_o());
        nbt.func_74768_a("z", p.func_177952_p());
        nbt.func_74778_a("dim", pos.func_239646_a_().func_240901_a_().toString());
    }

    @Nonnull
    public static GlobalPos readGlobalPos(@Nonnull CompoundNBT nbt) {
        return GlobalPos.func_239648_a_((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim"))), (BlockPos)new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")));
    }

    public static void writeGlobalPos(@Nonnull PacketBuffer buffer, @Nonnull GlobalPos pos) {
        buffer.func_192572_a(pos.func_239646_a_().func_240901_a_());
        buffer.func_179255_a(pos.func_218180_b());
    }

    @Nonnull
    public static GlobalPos readGlobalPos(@Nonnull PacketBuffer buffer) {
        return GlobalPos.func_239648_a_((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buffer.func_192575_l()), (BlockPos)buffer.func_179259_c());
    }

    @Nonnull
    public static String getDisplayPos(@Nonnull GlobalPos pos) {
        BlockPos p = pos.func_218180_b();
        return "X: " + p.func_177958_n() + " Y: " + p.func_177956_o() + " Z: " + p.func_177952_p();
    }

    @Nonnull
    public static String getDisplayDim(@Nonnull GlobalPos pos) {
        return pos.func_239646_a_().func_240901_a_().toString();
    }

    public static <T> boolean addWithCheck(@Nonnull Collection<T> list, @Nullable T toAdd) {
        if (toAdd != null && !list.contains(toAdd)) {
            list.add(toAdd);
            return true;
        }
        return false;
    }

    public static int getBrighterColor(int color, float factor) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)Math.min((float)red * factor, 255.0f);
        green = (int)Math.min((float)green * factor, 255.0f);
        blue = (int)Math.min((float)blue * factor, 255.0f);
        return red << 16 | green << 8 | blue;
    }

    public static String compact(long in) {
        if (in < 1000L) {
            return Long.toString(in);
        }
        int level = (int)(Math.log10(in) / 3.0) - 1;
        char pre = "kMGTPE".charAt(level);
        return String.format("%.1f%c", (double)in * COMPACT_SCALE[level], Character.valueOf(pre));
    }

    public static String compact(long in, String suffix) {
        if (in < 1000L) {
            return in + " " + suffix;
        }
        int level = (int)(Math.log10(in) / 3.0) - 1;
        char pre = "kMGTPE".charAt(level);
        return String.format("%.1f %c%s", (double)in * COMPACT_SCALE[level], Character.valueOf(pre), suffix);
    }

    public static boolean isLegalPassword(@Nonnull String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '!' && c < '\u007f') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T> T get(@Nonnull LazyOptional<T> lazyOptional) {
        if (lazyOptional.isPresent()) {
            return (T)lazyOptional.orElseThrow(IllegalStateException::new);
        }
        return null;
    }
}

