/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.GlobalPos;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.network.SFeedbackMessage;
import sonar.fluxnetworks.common.network.SNetworkUpdateMessage;
import sonar.fluxnetworks.common.storage.FluxChunkManager;
import sonar.fluxnetworks.common.storage.FluxNetworkData;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public class CEditConnectionsMessage
implements IMessage {
    private int networkID;
    private List<GlobalPos> list;
    private int flags;
    private String name;
    private int priority;
    private long limit;
    private boolean surgeMode;
    private boolean disableLimit;
    private boolean chunkLoading;

    public CEditConnectionsMessage() {
    }

    public CEditConnectionsMessage(int networkID, List<GlobalPos> list, int flags) {
        this.networkID = networkID;
        this.list = list;
        this.flags = flags;
    }

    public CEditConnectionsMessage(int networkID, List<GlobalPos> list, int flags, String name, int priority, long limit, boolean surgeMode, boolean disableLimit, boolean chunkLoading) {
        this.networkID = networkID;
        this.list = list;
        this.flags = flags;
        this.name = name;
        this.priority = priority;
        this.limit = limit;
        this.surgeMode = surgeMode;
        this.disableLimit = disableLimit;
        this.chunkLoading = chunkLoading;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_150787_b(this.networkID);
        buffer.func_150787_b(this.flags);
        buffer.func_150787_b(this.list.size());
        this.list.forEach(pos -> FluxUtils.writeGlobalPos(buffer, pos));
        if ((this.flags & 1) != 0) {
            buffer.func_211400_a(this.name, 256);
        }
        if ((this.flags & 2) != 0) {
            buffer.writeInt(this.priority);
        }
        if ((this.flags & 4) != 0) {
            buffer.writeLong(this.limit);
        }
        if ((this.flags & 8) != 0) {
            buffer.writeBoolean(this.surgeMode);
        }
        if ((this.flags & 0x10) != 0) {
            buffer.writeBoolean(this.disableLimit);
        }
        if ((this.flags & 0x20) != 0) {
            buffer.writeBoolean(this.chunkLoading);
        }
    }

    @Override
    public void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context) {
        PlayerEntity player = NetworkHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        IFluxNetwork network = FluxNetworkData.getNetwork(buffer.func_150792_a());
        if (!network.getPlayerAccess(player).canEdit()) {
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.NO_ADMIN), context);
            return;
        }
        int flags = buffer.func_150792_a();
        int size = buffer.func_150792_a();
        if (size == 0) {
            return;
        }
        ArrayList toEdit = new ArrayList();
        for (int i = 0; i < size; ++i) {
            network.getConnectionByPos(FluxUtils.readGlobalPos(buffer)).ifPresent(toEdit::add);
        }
        if (toEdit.isEmpty()) {
            return;
        }
        if ((flags & 0x40) != 0) {
            toEdit.forEach(IFluxDevice::disconnect);
            NetworkHandler.INSTANCE.reply(new SNetworkUpdateMessage(network, 23), context);
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.SUCCESS_2), context);
        } else {
            boolean editName = (flags & 1) != 0;
            boolean editPriority = (flags & 2) != 0;
            boolean editLimit = (flags & 4) != 0;
            boolean editSurgeMode = (flags & 8) != 0;
            boolean editDisableLimit = (flags & 0x10) != 0;
            boolean editChunkLoading = (flags & 0x20) != 0;
            String name = null;
            int priority = 0;
            long limit = 0L;
            boolean surgeMode = false;
            boolean disableLimit = false;
            boolean chunkLoading = false;
            if (editName) {
                name = buffer.func_150789_c(256);
            }
            if (editPriority) {
                priority = buffer.readInt();
            }
            if (editLimit) {
                limit = buffer.readLong();
            }
            if (editSurgeMode) {
                surgeMode = buffer.readBoolean();
            }
            if (editDisableLimit) {
                disableLimit = buffer.readBoolean();
            }
            if (editChunkLoading) {
                chunkLoading = buffer.readBoolean();
            }
            boolean sendBannedLoading = false;
            for (IFluxDevice d : toEdit) {
                if (!(d instanceof TileFluxDevice)) continue;
                TileFluxDevice t = (TileFluxDevice)d;
                if (editName) {
                    t.setCustomName(name);
                }
                if (editPriority) {
                    t.setPriority(priority);
                }
                if (editLimit) {
                    t.setTransferLimit(limit);
                }
                if (editSurgeMode) {
                    t.setSurgeMode(surgeMode);
                }
                if (editDisableLimit) {
                    t.setDisableLimit(disableLimit);
                }
                if (editChunkLoading && !t.getDeviceType().isStorage()) {
                    if (FluxConfig.enableChunkLoading) {
                        if (chunkLoading && !t.isForcedLoading()) {
                            FluxChunkManager.addChunkLoader(t);
                        } else if (!chunkLoading && t.isForcedLoading()) {
                            FluxChunkManager.removeChunkLoader(t);
                        }
                        t.setForcedLoading(FluxChunkManager.isChunkLoader(t));
                    } else {
                        t.setForcedLoading(false);
                        sendBannedLoading = true;
                    }
                }
                t.sendFullUpdatePacket();
            }
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.SUCCESS), context);
            if (sendBannedLoading) {
                NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.BANNED_LOADING), context);
            }
        }
    }
}

