/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.CCreateNetworkMessage;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.network.SFeedbackMessage;
import sonar.fluxnetworks.common.network.SNetworkUpdateMessage;
import sonar.fluxnetworks.common.storage.FluxNetworkData;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public class CEditNetworkMessage
extends CCreateNetworkMessage {
    private int networkID;

    public CEditNetworkMessage() {
    }

    public CEditNetworkMessage(int networkID, String name, int color, SecurityType security, String password) {
        super(name, color, security, password);
        this.networkID = networkID;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        super.encode(buffer);
        buffer.func_150787_b(this.networkID);
    }

    @Override
    protected void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context, PlayerEntity player) {
        int networkID = buffer.func_150792_a();
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (!network.isValid()) {
            return;
        }
        if (network.getPlayerAccess(player).canEdit()) {
            if (!network.getNetworkName().equals(this.name)) {
                network.setNetworkName(this.name);
            }
            if (network.getNetworkColor() != this.color) {
                network.setNetworkColor(this.color);
                List<IFluxDevice> list = network.getConnections(FluxLogicType.ANY);
                list.forEach(device -> {
                    if (device instanceof TileFluxDevice) {
                        ((TileFluxDevice)device).sendFullUpdatePacket();
                    }
                });
            }
            if (FluxUtils.isLegalPassword(this.password)) {
                network.getSecurity().set(this.security, this.password);
            } else {
                NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.ILLEGAL_PASSWORD), context);
            }
            NetworkHandler.INSTANCE.reply(new SNetworkUpdateMessage(network, 21), context);
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.SUCCESS_2), context);
        } else {
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.NO_ADMIN), context);
        }
    }
}

