/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.network.SNetworkUpdateMessage;
import sonar.fluxnetworks.common.storage.FluxNetworkData;

public class CNetworkUpdateMessage
implements IMessage {
    private IntList list;
    private int flags;

    public CNetworkUpdateMessage() {
    }

    public CNetworkUpdateMessage(int networkID, int flags) {
        this.list = new IntArrayList();
        this.list.add(networkID);
        this.flags = flags;
    }

    public CNetworkUpdateMessage(@Nonnull Collection<IFluxNetwork> networks, int flags) {
        this.list = new IntArrayList();
        networks.forEach(n -> this.list.add(n.getNetworkID()));
        this.flags = flags;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_150787_b(this.flags);
        buffer.func_150787_b(this.list.size());
        this.list.forEach(arg_0 -> ((PacketBuffer)buffer).func_150787_b(arg_0));
    }

    @Override
    public void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context) {
        int flags = buffer.func_150792_a();
        int size = buffer.func_150792_a();
        ArrayList<IFluxNetwork> networks = new ArrayList<IFluxNetwork>();
        for (int i = 0; i < size; ++i) {
            IFluxNetwork network = FluxNetworkData.getNetwork(buffer.func_150792_a());
            if (!network.isValid()) continue;
            networks.add(network);
        }
        if (!networks.isEmpty()) {
            NetworkHandler.INSTANCE.reply(new SNetworkUpdateMessage(networks, flags), context);
        }
    }
}

