/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.storage;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.storage.FluxNetworkData;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public class FluxChunkManager {
    private static final TicketType<TileFluxDevice> FLUX_TICKET_TYPE = TicketType.func_219484_a((String)"fluxnetworks:chunk_loading", Comparator.comparing(TileEntity::func_174877_v));
    private static final int LOAD_DISTANCE = 2;

    public static void loadWorld(ServerWorld world) {
        if (!FluxConfig.enableChunkLoading) {
            return;
        }
        RegistryKey dim = world.func_234923_W_();
        LongSet tickets = FluxNetworkData.getTickets((RegistryKey<World>)dim);
        ObjectArraySet chunkPosSet = new ObjectArraySet();
        if (!tickets.isEmpty()) {
            ServerChunkProvider chunkProvider = world.func_72863_F();
            LongIterator iterator = tickets.iterator();
            while (iterator.hasNext()) {
                BlockPos blockPos = BlockPos.func_218283_e((long)iterator.nextLong());
                TileEntity tile = world.func_175625_s(blockPos);
                if (tile instanceof TileFluxDevice) {
                    TileFluxDevice flux = (TileFluxDevice)tile;
                    ChunkPos chunkPos = new ChunkPos(blockPos);
                    chunkPosSet.add(chunkPos);
                    chunkProvider.func_217228_a(FLUX_TICKET_TYPE, chunkPos, 2, (Object)flux);
                    flux.setForcedLoading(true);
                    flux.sendFullUpdatePacket();
                    continue;
                }
                iterator.remove();
            }
        }
        FluxNetworks.LOGGER.info("Loading {} chunks in {} by {} flux devices", (Object)chunkPosSet.size(), (Object)dim.func_240901_a_(), (Object)tickets.size());
    }

    public static void tickWorld(@Nonnull ServerWorld world) {
        if (!FluxNetworkData.getTickets((RegistryKey<World>)world.func_234923_W_()).isEmpty()) {
            world.func_82742_i();
        }
    }

    public static void addChunkLoader(@Nonnull TileFluxDevice tile) {
        ServerWorld world = (ServerWorld)tile.getFluxWorld();
        RegistryKey dim = world.func_234923_W_();
        BlockPos blockPos = tile.func_174877_v();
        if (FluxNetworkData.getTickets((RegistryKey<World>)dim).add(blockPos.func_218275_a())) {
            ChunkPos chunkPos = new ChunkPos(blockPos);
            world.func_217349_x(blockPos);
            world.func_72863_F().func_217228_a(FLUX_TICKET_TYPE, chunkPos, 2, (Object)tile);
            FluxNetworks.LOGGER.debug("Adding chunk loader in {}, chunk: {} at {}", (Object)dim.func_240901_a_(), (Object)chunkPos, (Object)blockPos);
        } else {
            FluxNetworks.LOGGER.warn("There's already a chunk loader added in {} at {}", (Object)dim.func_240901_a_(), (Object)blockPos);
        }
    }

    public static void removeChunkLoader(@Nonnull TileFluxDevice tile) {
        ServerWorld world = (ServerWorld)tile.getFluxWorld();
        RegistryKey dim = world.func_234923_W_();
        BlockPos blockPos = tile.func_174877_v();
        if (FluxNetworkData.getTickets((RegistryKey<World>)dim).remove(blockPos.func_218275_a())) {
            ChunkPos chunkPos = new ChunkPos(blockPos);
            world.func_72863_F().func_217222_b(FLUX_TICKET_TYPE, chunkPos, 2, (Object)tile);
            FluxNetworks.LOGGER.debug("Removing chunk loader in {}, chunk: {} at {}", (Object)dim.func_240901_a_(), (Object)chunkPos, (Object)blockPos);
        } else {
            FluxNetworks.LOGGER.warn("There's no such a chunk loader to remove in {} at {}", (Object)dim.func_240901_a_(), (Object)blockPos);
        }
    }

    public static boolean isChunkLoader(@Nonnull TileFluxDevice tile) {
        RegistryKey dim = tile.getFluxWorld().func_234923_W_();
        BlockPos blockPos = tile.func_174877_v();
        return FluxNetworkData.getTickets((RegistryKey<World>)dim).contains(blockPos.func_218275_a());
    }
}

