/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import com.google.gson.JsonObject;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FurnaceRecipeBuilder
extends AbstractItemStackRecipeBuilder<FurnaceRecipeBuilder> {
    private static final Logger logger = LogManager.getLogger();
    private Ingredient ingredient;
    private float experience = 0.0f;
    private int cookingTime = 200;

    protected FurnaceRecipeBuilder(IRecipeSerializer<?> serializer, ResourceLocation id, ItemStack result) {
        super(serializer, id, result);
    }

    public static FurnaceRecipeBuilder smelting(IItemProvider result) {
        return FurnaceRecipeBuilder.smelting(result, 1);
    }

    public static FurnaceRecipeBuilder smelting(IItemProvider result, int count) {
        return FurnaceRecipeBuilder.smelting(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder smelting(IItemProvider result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.smelting(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder smelting(ItemStack result) {
        return FurnaceRecipeBuilder.smelting(result, result.func_77973_b().getRegistryName());
    }

    public static FurnaceRecipeBuilder smelting(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder((IRecipeSerializer<?>)IRecipeSerializer.field_222171_o, id, result).cookingTime(200);
    }

    public static FurnaceRecipeBuilder blasting(IItemProvider result) {
        return FurnaceRecipeBuilder.blasting(result, 1);
    }

    public static FurnaceRecipeBuilder blasting(IItemProvider result, int count) {
        return FurnaceRecipeBuilder.blasting(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder blasting(IItemProvider result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.blasting(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder blasting(ItemStack result) {
        return FurnaceRecipeBuilder.blasting(result, result.func_77973_b().getRegistryName());
    }

    public static FurnaceRecipeBuilder blasting(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder((IRecipeSerializer<?>)IRecipeSerializer.field_222172_p, id, result).cookingTime(100);
    }

    public static FurnaceRecipeBuilder smoking(IItemProvider result) {
        return FurnaceRecipeBuilder.smoking(result, 1);
    }

    public static FurnaceRecipeBuilder smoking(IItemProvider result, int count) {
        return FurnaceRecipeBuilder.smoking(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder smoking(IItemProvider result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.smoking(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder smoking(ItemStack result) {
        return FurnaceRecipeBuilder.smoking(result, result.func_77973_b().getRegistryName());
    }

    public static FurnaceRecipeBuilder smoking(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder((IRecipeSerializer<?>)IRecipeSerializer.field_222173_q, id, result).cookingTime(100);
    }

    public static FurnaceRecipeBuilder campfire(IItemProvider result) {
        return FurnaceRecipeBuilder.campfire(result, 1);
    }

    public static FurnaceRecipeBuilder campfire(IItemProvider result, int count) {
        return FurnaceRecipeBuilder.campfire(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder campfire(IItemProvider result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.campfire(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder campfire(ItemStack result) {
        return FurnaceRecipeBuilder.campfire(result, result.func_77973_b().getRegistryName());
    }

    public static FurnaceRecipeBuilder campfire(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder((IRecipeSerializer<?>)IRecipeSerializer.field_222174_r, id, result).cookingTime(600);
    }

    public FurnaceRecipeBuilder ingredient(Tag<Item> tag) {
        this.addAutoCriteria(tag);
        this.ingredient = Ingredient.func_199805_a(tag);
        return this;
    }

    public FurnaceRecipeBuilder ingredient(IItemProvider item) {
        this.addAutoCriteria(item);
        this.ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        return this;
    }

    public FurnaceRecipeBuilder ingredient(Ingredient ingredient) {
        if (this.generateCriteria) {
            logger.warn("Criteria not automatically generated for raw ingredient.", new Throwable("Here, have a stack trace"));
        }
        this.ingredient = ingredient;
        return this;
    }

    public FurnaceRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    public FurnaceRecipeBuilder cookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return this;
    }

    @Override
    public AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe _build() {
        return new FinishedFurnaceRecipe();
    }

    public class FinishedFurnaceRecipe
    extends AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe {
        @Override
        public void func_218610_a(JsonObject json) {
            super.func_218610_a(json);
            json.add("ingredient", FurnaceRecipeBuilder.this.ingredient.func_200304_c());
            json.addProperty("experience", (Number)Float.valueOf(FurnaceRecipeBuilder.this.experience));
            json.addProperty("cookingtime", (Number)FurnaceRecipeBuilder.this.cookingTime);
        }
    }
}

