/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;

public class EntityTypeArgument
implements ArgumentType<EntityType<?>> {
    private static final Collection<String> EXAMPLES = ImmutableList.of((Object)"item", (Object)"minecraft:pig", (Object)"minecraft:wither");
    private static final DynamicCommandExceptionType MISSING = new DynamicCommandExceptionType(p -> new TranslationTextComponent("codechickenlib:argument.entity_type.invalid", new Object[]{p}));

    public EntityType<?> parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation loc = ResourceLocation.func_195826_a((StringReader)reader);
        return (EntityType)Registry.field_212629_r.func_241873_b(loc).orElseThrow(() -> MISSING.create((Object)loc));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_212476_a(Registry.field_212629_r.func_148742_b().stream(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static EntityTypeArgument entityType() {
        return new EntityTypeArgument();
    }

    public static EntityType<?> getEntityType(CommandContext<CommandSource> src, String name) {
        return (EntityType)src.getArgument(name, EntityType.class);
    }

    public static class Serializer
    implements IArgumentSerializer<EntityTypeArgument> {
        public void write(EntityTypeArgument argument, PacketBuffer buffer) {
        }

        public EntityTypeArgument read(PacketBuffer buffer) {
            return new EntityTypeArgument();
        }

        public void write(EntityTypeArgument p_212244_1_, JsonObject p_212244_2_) {
        }
    }
}

