/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.client.network.login.IClientLoginNetHandler;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;

public class PacketCustomChannelBuilder {
    private static final Supplier<String> CONST_1 = () -> "1";
    private static final Predicate<String> TRUE = e -> true;
    private final NetworkRegistry.ChannelBuilder parent;
    private final ResourceLocation channelName;
    private Supplier<String> networkProtocolVersion = CONST_1;
    private Predicate<String> clientAcceptedVersions = TRUE;
    private Predicate<String> serverAcceptedVersions = TRUE;
    private ICustomPacketHandler.IClientPacketHandler clientHandler;
    private ICustomPacketHandler.IServerPacketHandler serverHandler;
    private ICustomPacketHandler.ILoginPacketHandler loginHandler;

    private PacketCustomChannelBuilder(ResourceLocation channelName) {
        this.channelName = channelName;
        this.parent = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName);
    }

    public static PacketCustomChannelBuilder named(ResourceLocation channelName) {
        return new PacketCustomChannelBuilder(channelName);
    }

    public PacketCustomChannelBuilder networkProtocolVersion(Supplier<String> networkProtocolVersion) {
        this.networkProtocolVersion = networkProtocolVersion;
        return this;
    }

    public PacketCustomChannelBuilder clientAcceptedVersions(Predicate<String> clientAcceptedVersions) {
        this.clientAcceptedVersions = clientAcceptedVersions;
        return this;
    }

    public PacketCustomChannelBuilder serverAcceptedVersions(Predicate<String> serverAcceptedVersions) {
        this.serverAcceptedVersions = serverAcceptedVersions;
        return this;
    }

    public PacketCustomChannelBuilder assignClientHandler(Supplier<Supplier<ICustomPacketHandler.IClientPacketHandler>> clientHandler) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.clientHandler = clientHandler.get().get();
        }
        return this;
    }

    public PacketCustomChannelBuilder assignServerHandler(Supplier<Supplier<ICustomPacketHandler.IServerPacketHandler>> serverHandler) {
        this.serverHandler = serverHandler.get().get();
        return this;
    }

    public PacketCustomChannelBuilder assignLoginHandler(Supplier<Supplier<ICustomPacketHandler.ILoginPacketHandler>> loginHandler) {
        this.loginHandler = loginHandler.get().get();
        return this;
    }

    public synchronized EventNetworkChannel build() {
        EventNetworkChannel channel = this.parent.networkProtocolVersion(this.networkProtocolVersion).clientAcceptedVersions(this.clientAcceptedVersions).serverAcceptedVersions(this.serverAcceptedVersions).eventNetworkChannel();
        if (this.clientHandler != null) {
            channel.registerObject((Object)new ClientHandler(this.clientHandler));
        }
        if (this.serverHandler != null) {
            channel.registerObject((Object)new ServerHandler(this.serverHandler));
        }
        if (this.loginHandler != null) {
            channel.registerObject((Object)new LoginHandler(this.loginHandler));
        }
        return channel;
    }

    public static class LoginHandler {
        private final ICustomPacketHandler.ILoginPacketHandler packetHandler;

        public LoginHandler(ICustomPacketHandler.ILoginPacketHandler packetHandler) {
            this.packetHandler = packetHandler;
        }

        @SubscribeEvent
        public void onGatherLoginPayloads(NetworkEvent.GatherLoginPayloadsEvent event) {
            this.packetHandler.gatherLoginPackets((ctx, packetSupplier) -> {
                PacketCustom packet = (PacketCustom)packetSupplier.get();
                event.add(packet.toPacketBuffer(), packet.getChannel(), ctx);
            });
        }

        @SubscribeEvent
        public void onClientPayload(NetworkEvent.LoginPayloadEvent event) {
            PacketCustom packet = new PacketCustom((ByteBuf)event.getPayload());
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            INetHandler netHandler = ctx.getNetworkManager().func_150729_e();
            ctx.setPacketHandled(true);
            if (netHandler instanceof ClientLoginNetHandler) {
                ClientLoginNetHandler nh = (ClientLoginNetHandler)netHandler;
                this.packetHandler.handleLoginPacket(packet, Minecraft.func_71410_x(), (IClientLoginNetHandler)nh, ctx);
                ctx.getPacketDispatcher().sendPacket(new ResourceLocation("fml:handshake"), new PacketBuffer(Unpooled.buffer().writeByte(99)));
            }
        }
    }

    public static class ServerHandler {
        private final ICustomPacketHandler.IServerPacketHandler packetHandler;

        public ServerHandler(ICustomPacketHandler.IServerPacketHandler packetHandler) {
            this.packetHandler = packetHandler;
        }

        @SubscribeEvent
        public void onServerPayload(NetworkEvent.ClientCustomPayloadEvent event) {
            PacketCustom packet = new PacketCustom((ByteBuf)event.getPayload());
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            INetHandler netHandler = ctx.getNetworkManager().func_150729_e();
            ctx.setPacketHandled(true);
            if (netHandler instanceof ServerPlayNetHandler) {
                ServerPlayNetHandler nh = (ServerPlayNetHandler)netHandler;
                ctx.enqueueWork(() -> this.packetHandler.handlePacket(packet, nh.field_147369_b, (IServerPlayNetHandler)nh));
            }
        }
    }

    public static class ClientHandler {
        private final ICustomPacketHandler.IClientPacketHandler packetHandler;

        public ClientHandler(ICustomPacketHandler.IClientPacketHandler packetHandler) {
            this.packetHandler = packetHandler;
        }

        @SubscribeEvent
        public void onClientPayload(NetworkEvent.ServerCustomPayloadEvent event) {
            if (event instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
                return;
            }
            PacketCustom packet = new PacketCustom((ByteBuf)event.getPayload());
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            INetHandler netHandler = ctx.getNetworkManager().func_150729_e();
            ctx.setPacketHandled(true);
            if (netHandler instanceof ClientPlayNetHandler) {
                ClientPlayNetHandler nh = (ClientPlayNetHandler)netHandler;
                ctx.enqueueWork(() -> this.packetHandler.handlePacket(packet, Minecraft.func_71410_x(), (IClientPlayNetHandler)nh));
            }
        }
    }
}

