/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.AssetShaderObject;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.SimpleShaderObject;
import codechicken.lib.render.shader.Uniform;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;

public class ShaderProgramBuilder {
    private static final Consumer<UniformCache> NULL_CALLBACK = e -> {};
    private final Map<String, ShaderObject> shaders = new HashMap<String, ShaderObject>();
    private Consumer<UniformCache> cacheCallback;

    private ShaderProgramBuilder() {
    }

    public static ShaderProgramBuilder builder() {
        return new ShaderProgramBuilder();
    }

    public ShaderProgramBuilder addShader(String name, Consumer<ShaderObjectBuilder> func) {
        ShaderObjectBuilder builder = new ShaderObjectBuilder(name);
        func.accept(builder);
        return this.addShader(builder.build());
    }

    public ShaderProgramBuilder addShader(ShaderObject shader) {
        if (this.shaders.containsKey(shader.getName())) {
            throw new IllegalArgumentException("Duplicate shader with name: " + shader.getName());
        }
        this.shaders.put(shader.getName(), shader);
        return this;
    }

    public ShaderProgramBuilder whenUsed(Consumer<UniformCache> callback) {
        this.cacheCallback = this.cacheCallback == null ? callback : this.cacheCallback.andThen(callback);
        return this;
    }

    public ShaderProgram build() {
        return new ShaderProgram(this.shaders.values(), this.cacheCallback == null ? NULL_CALLBACK : this.cacheCallback);
    }

    public static class ShaderObjectBuilder {
        private final String name;
        private final Map<String, Uniform> uniforms = new HashMap<String, Uniform>();
        private ShaderObject.ShaderType type;
        private String simpleSource;
        private ResourceLocation assetSource;

        private ShaderObjectBuilder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public ShaderObjectBuilder type(ShaderObject.ShaderType type) {
            if (this.type != null) {
                throw new IllegalArgumentException("Type already set.");
            }
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public ShaderObjectBuilder source(String source) {
            if (this.simpleSource != null || this.assetSource != null) {
                throw new IllegalArgumentException("Source already set.");
            }
            this.simpleSource = Objects.requireNonNull(source);
            return this;
        }

        public ShaderObjectBuilder source(ResourceLocation asset) {
            if (this.assetSource != null || this.simpleSource != null) {
                throw new IllegalArgumentException("Source already set.");
            }
            this.assetSource = Objects.requireNonNull(asset);
            return this;
        }

        public ShaderObjectBuilder uniform(String name, UniformType type) {
            if (this.uniforms.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate uniform with name: " + name);
            }
            this.uniforms.put(name, new Uniform(name, type));
            return this;
        }

        private ShaderObject build() {
            if (this.type == null) {
                throw new IllegalStateException("Type not set.");
            }
            if (this.simpleSource == null && this.assetSource == null) {
                throw new IllegalStateException("SimpleSource or AssetSource not set.");
            }
            if (this.simpleSource != null) {
                return new SimpleShaderObject(this.name, this.type, this.uniforms.values(), this.simpleSource);
            }
            return new AssetShaderObject(this.name, this.type, this.uniforms.values(), this.assetSource);
        }
    }
}

