/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.base;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.breaker.BlockBreaker;
import com.lothrazar.cyclic.block.cable.energy.TileCableEnergy;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.net.PacketEnergySync;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilFakePlayer;
import com.lothrazar.cyclic.util.UtilFluid;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityBase
extends TileEntity
implements IInventory {
    public static final String NBTINV = "inv";
    public static final String NBTENERGY = "energy";
    public static final int MENERGY = 64000;
    protected int needsRedstone = 1;
    protected int render = 0;
    protected int timer;

    public TileEntityBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    protected PlayerEntity getLookingPlayer(int maxRange, boolean mustCrouch) {
        List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - maxRange), (double)(this.field_174879_c.func_177956_o() - maxRange), (double)(this.field_174879_c.func_177952_p() - maxRange), (double)(this.field_174879_c.func_177958_n() + maxRange), (double)(this.field_174879_c.func_177956_o() + maxRange), (double)(this.field_174879_c.func_177952_p() + maxRange)));
        for (PlayerEntity player : players) {
            if (mustCrouch && !player.func_213453_ef()) continue;
            Vector3d positionEyes = player.func_174824_e(1.0f);
            Vector3d look = player.func_70676_i(1.0f);
            Vector3d visionWithLength = positionEyes.func_72441_c(look.field_72450_a * (double)maxRange, look.field_72448_b * (double)maxRange, look.field_72449_c * (double)maxRange);
            BlockRayTraceResult rayTrace = this.field_145850_b.func_217299_a(new RayTraceContext(positionEyes, visionWithLength, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
            if (!this.field_174879_c.equals((Object)rayTrace.func_216350_a())) continue;
            return player;
        }
        return null;
    }

    public void tryDumpFakePlayerInvo(WeakReference<FakePlayer> fp, boolean includeMainHand) {
        int start = includeMainHand ? 0 : 1;
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        for (int i = start; i < ((FakePlayer)fp.get()).field_71071_by.field_70462_a.size(); ++i) {
            ItemStack s = (ItemStack)((FakePlayer)fp.get()).field_71071_by.field_70462_a.get(i);
            if (s.func_190926_b()) continue;
            toDrop.add(s.func_77946_l());
            ((FakePlayer)fp.get()).field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        UtilItemStack.drop(this.field_145850_b, this.field_174879_c.func_177984_a(), toDrop);
    }

    public static void tryEquipItem(ItemStack item, WeakReference<FakePlayer> fp, Hand hand) {
        if (fp == null) {
            return;
        }
        ((FakePlayer)fp.get()).func_184611_a(hand, item);
    }

    public static void syncEquippedItem(LazyOptional<IItemHandler> i, WeakReference<FakePlayer> fp, int slot, Hand hand) {
        if (fp == null) {
            return;
        }
        i.ifPresent(inv -> {
            inv.extractItem(slot, 64, false);
            inv.insertItem(slot, ((FakePlayer)fp.get()).func_184586_b(hand), false);
        });
    }

    public static void tryEquipItem(LazyOptional<IItemHandler> i, WeakReference<FakePlayer> fp, int slot, Hand hand) {
        if (fp == null) {
            return;
        }
        i.ifPresent(inv -> {
            ItemStack maybeTool = inv.getStackInSlot(0);
            if (!maybeTool.func_190926_b() && maybeTool.func_190916_E() <= 0) {
                maybeTool = ItemStack.field_190927_a;
            }
            if (!maybeTool.equals(((FakePlayer)fp.get()).func_184586_b(hand))) {
                ((FakePlayer)fp.get()).func_184611_a(hand, maybeTool);
            }
        });
    }

    public static ActionResultType rightClickBlock(WeakReference<FakePlayer> fakePlayer, World world, BlockPos targetPos, Hand hand, @Nullable Direction facing) throws Exception {
        if (fakePlayer == null) {
            return ActionResultType.FAIL;
        }
        Direction placementOn = facing == null ? ((FakePlayer)fakePlayer.get()).func_184172_bi() : facing;
        BlockRayTraceResult blockraytraceresult = new BlockRayTraceResult(((FakePlayer)fakePlayer.get()).func_70040_Z(), placementOn, targetPos, true);
        ActionResultType result = ((FakePlayer)fakePlayer.get()).field_71134_c.func_219441_a((ServerPlayerEntity)fakePlayer.get(), world, ((FakePlayer)fakePlayer.get()).func_184586_b(hand), hand, blockraytraceresult);
        return result;
    }

    public static boolean tryHarvestBlock(WeakReference<FakePlayer> fakePlayer, World world, BlockPos targetPos) {
        if (fakePlayer == null) {
            return false;
        }
        return ((FakePlayer)fakePlayer.get()).field_71134_c.func_180237_b(targetPos);
    }

    public WeakReference<FakePlayer> setupBeforeTrigger(ServerWorld sw, String name, UUID uuid) {
        WeakReference<FakePlayer> fakePlayer = UtilFakePlayer.initFakePlayer(sw, uuid, name);
        if (fakePlayer == null) {
            ModCyclic.LOGGER.error("Fake player failed to init " + name + " " + uuid);
            return null;
        }
        ((FakePlayer)fakePlayer.get()).func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        ((FakePlayer)fakePlayer.get()).field_70177_z = UtilEntity.getYawFromFacing(this.getCurrentFacing());
        return fakePlayer;
    }

    public WeakReference<FakePlayer> setupBeforeTrigger(ServerWorld sw, String name) {
        return this.setupBeforeTrigger(sw, name, UUID.randomUUID());
    }

    public void setLitProperty(boolean lit) {
        BlockState st = this.func_195044_w();
        if (!st.func_235901_b_((Property)BlockBase.LIT)) {
            return;
        }
        boolean previous = (Boolean)st.func_177229_b((Property)BlockBreaker.LIT);
        if (previous != lit) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)st.func_206870_a((Property)BlockBreaker.LIT, (Comparable)Boolean.valueOf(lit)));
        }
    }

    public Direction getCurrentFacing() {
        if (this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
            return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        if (this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        }
        return null;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT syncData = new CompoundNBT();
        this.func_189515_b(syncData);
        return syncData;
    }

    protected BlockPos getCurrentFacingPos(int distance) {
        Direction f = this.getCurrentFacing();
        if (f != null) {
            return this.field_174879_c.func_177967_a(f, distance);
        }
        return this.field_174879_c;
    }

    protected BlockPos getCurrentFacingPos() {
        return this.getCurrentFacingPos(1);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public boolean isPowered() {
        return this.func_145831_w().func_175640_z(this.func_174877_v());
    }

    public boolean requiresRedstone() {
        return this.needsRedstone == 1;
    }

    public void moveFluids(Direction myFacingDir, int toFlow, IFluidHandler tank) {
        Direction themFacingMe = myFacingDir.func_176734_d();
        if (tank == null || tank.getFluidInTank(0).getAmount() <= 0) {
            return;
        }
        BlockPos posTarget = this.field_174879_c.func_177972_a(myFacingDir);
        UtilFluid.tryFillPositionFromTank(this.field_145850_b, posTarget, themFacingMe, tank, toFlow);
    }

    public boolean moveItems(Direction myFacingDir, int max, IItemHandler handlerHere) {
        if (this.field_145850_b.func_201670_d()) {
            return false;
        }
        if (handlerHere == null) {
            return false;
        }
        Direction themFacingMe = myFacingDir.func_176734_d();
        BlockPos posTarget = this.field_174879_c.func_177972_a(myFacingDir);
        TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
        if (tileTarget == null) {
            return false;
        }
        IItemHandler handlerOutput = (IItemHandler)tileTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, themFacingMe).orElse(null);
        if (handlerOutput == null) {
            return false;
        }
        if (handlerHere != null && handlerOutput != null) {
            int sizeAfter;
            int theslot = 0;
            ItemStack drain = handlerHere.getStackInSlot(theslot).func_77946_l();
            int sizeStarted = drain.func_190916_E();
            if (!drain.func_190926_b()) {
                for (int slot = 0; slot < handlerOutput.getSlots() && !(drain = handlerOutput.insertItem(slot, drain, false)).func_190926_b(); ++slot) {
                }
            }
            if ((sizeAfter = sizeStarted - drain.func_190916_E()) > 0) {
                handlerHere.extractItem(theslot, sizeAfter, false);
            }
            return true;
        }
        return false;
    }

    protected void moveEnergy(Direction myFacingDir, int quantity) {
        int drain;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IEnergyStorage handlerHere = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, myFacingDir).orElse(null);
        if (handlerHere == null || handlerHere.getEnergyStored() == 0) {
            return;
        }
        Direction themFacingMe = myFacingDir.func_176734_d();
        BlockPos posTarget = this.field_174879_c.func_177972_a(myFacingDir);
        TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
        if (tileTarget == null) {
            return;
        }
        IEnergyStorage handlerOutput = (IEnergyStorage)tileTarget.getCapability(CapabilityEnergy.ENERGY, themFacingMe).orElse(null);
        if (handlerOutput == null) {
            return;
        }
        if (handlerHere != null && handlerOutput != null && handlerHere.canExtract() && handlerOutput.canReceive() && (drain = handlerHere.extractEnergy(quantity, true)) > 0) {
            int filled = handlerOutput.receiveEnergy(drain, false);
            handlerHere.extractEnergy(filled, false);
            if (filled > 0 && tileTarget instanceof TileCableEnergy) {
                TileCableEnergy cable = (TileCableEnergy)tileTarget;
                cable.updateIncomingEnergyFace(themFacingMe);
            }
        }
    }

    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.needsRedstone = tag.func_74762_e("needsRedstone");
        this.render = tag.func_74762_e("renderParticles");
        this.timer = tag.func_74762_e("timer");
        super.func_230337_a_(bs, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("needsRedstone", this.needsRedstone);
        tag.func_74768_a("renderParticles", this.render);
        tag.func_74768_a("timer", this.timer);
        return super.func_189515_b(tag);
    }

    public abstract void setField(int var1, int var2);

    public abstract int getField(int var1);

    public void setNeedsRedstone(int value) {
        this.needsRedstone = value % 2;
    }

    public void setFluid(FluidStack fluid) {
    }

    @Deprecated
    public int func_70302_i_() {
        return 0;
    }

    @Deprecated
    public boolean func_191420_l() {
        return true;
    }

    @Deprecated
    public ItemStack func_70301_a(int index) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public ItemStack func_70298_a(int index, int count) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public void func_70299_a(int index, ItemStack stack) {
    }

    @Deprecated
    public boolean func_70300_a(PlayerEntity player) {
        return false;
    }

    @Deprecated
    public void func_174888_l() {
    }

    public void setFieldString(int field, String value) {
    }

    public String getFieldString(int field) {
        return null;
    }

    public int getEnergy() {
        return this.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public void setEnergy(int value) {
        IEnergyStorage energ = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (energ != null && energ instanceof CustomEnergyStorage) {
            ((CustomEnergyStorage)energ).setEnergy(value);
        }
    }

    protected void syncEnergy() {
        IEnergyStorage energ;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L && (energ = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY).orElse(null)) != null) {
            PacketRegistry.sendToAllClients(this.func_145831_w(), new PacketEnergySync(this.func_174877_v(), energ.getEnergyStored()));
        }
    }
}

