/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.battery.EnumBatteryPercent;
import com.lothrazar.cyclic.block.battery.ScreenBattery;
import com.lothrazar.cyclic.block.battery.TileBattery;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.ContainerScreenRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockBattery
extends BlockBase {
    public static EnumProperty<EnumBatteryPercent> PERCENT = EnumProperty.func_177709_a((String)"percent", EnumBatteryPercent.class);

    public BlockBattery(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(1.8f));
        this.setHasGui();
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PERCENT, (Comparable)((Object)EnumBatteryPercent.ZERO)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
        ScreenManager.func_216911_a(ContainerScreenRegistry.batteryCont, ScreenBattery::new);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT}).func_206894_a(new Property[]{PERCENT});
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity ent, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, ent, stack);
        ItemStack battery = new ItemStack((IItemProvider)this);
        if (ent != null) {
            IEnergyStorage handlerHere = (IEnergyStorage)ent.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            IEnergyStorage storage = (IEnergyStorage)battery.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (storage != null) {
                ((CustomEnergyStorage)storage).setEnergy(handlerHere.getEnergyStored());
            }
        }
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), battery));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileBattery();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        try {
            TileBattery container;
            CustomEnergyStorage storageTile;
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (storage != null && (storageTile = (CustomEnergyStorage)((Object)(container = (TileBattery)world.func_175625_s(pos)).getCapability(CapabilityEnergy.ENERGY, null).orElse(null))) != null) {
                storageTile.setEnergy(storage.getEnergyStored());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

