/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.beaconpotion;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.beaconpotion.ContainerPotion;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.data.EntityFilterType;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TilePotion
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    static final int MAX = 64000;
    private static final int TICKS_FIRE_PER = 60;
    static final int TICKS_PER_DURATION = 160000;
    private static final int POTION_TICKS = 400;
    private static final int MAX_RADIUS = 64;
    private int radius = 64;
    public static ForgeConfigSpec.IntValue POWERCONF;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private List<EffectInstance> effects = new ArrayList<EffectInstance>();
    EntityFilterType entityFilter = EntityFilterType.PLAYERS;
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77962_s();
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TilePotion() {
        super(TileRegistry.beacon);
        this.timer = 0;
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.effects.size() == 0) {
            this.timer = 0;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        this.energy.extractEnergy(cost, false);
        --this.timer;
        if (this.timer > 0) {
            this.tryAffectEntities(cost);
            return;
        }
        this.effects.clear();
        ItemStack s = this.inventory.getStackInSlot(0);
        if (s.func_190926_b()) {
            return;
        }
        List newEffects = PotionUtils.func_185189_a((ItemStack)s);
        if (newEffects.size() > 0) {
            this.pullFromItem(newEffects);
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerPotion(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.radius = tag.func_74762_e("radius");
        this.entityFilter = EntityFilterType.values()[tag.func_74762_e("entityFilter")];
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        if (tag.func_150297_b("Effects", 9)) {
            ListNBT listnbt = tag.func_150295_c("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < listnbt.size(); ++i) {
                EffectInstance effectinstance = EffectInstance.func_82722_b((CompoundNBT)listnbt.func_150305_b(i));
                if (effectinstance == null) continue;
                this.effects.add(effectinstance);
            }
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("radius", this.radius);
        tag.func_74768_a("entityFilter", this.entityFilter.ordinal());
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        if (!this.effects.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.effects) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            tag.func_218657_a("Effects", (INBT)listnbt);
        }
        return super.func_189515_b(tag);
    }

    private void pullFromItem(List<EffectInstance> newEffects) {
        this.timer = 160000;
        this.setLitProperty(true);
        int maxDur = 0;
        for (EffectInstance eff : newEffects) {
            if (!this.isPotionValid(eff)) continue;
            this.effects.add(new EffectInstance(eff.func_188419_a(), 400, eff.func_76458_c(), true, false));
            maxDur = Math.max(eff.func_76459_b(), maxDur);
        }
        this.inventory.extractItem(0, 1, false);
    }

    private void tryAffectEntities(int repair) {
        int affected;
        if (this.timer % 60 == 0 && this.effects.size() > 0 && this.energy.getEnergyStored() >= repair && (affected = this.affectEntities()) > 0) {
            this.energy.extractEnergy(repair, false);
        }
    }

    private int affectEntities() {
        boolean showParticles = false;
        int affecdted = 0;
        List<? extends LivingEntity> list = this.entityFilter.getEntities(this.field_145850_b, this.field_174879_c, this.radius);
        for (LivingEntity livingEntity : list) {
            if (livingEntity == null) continue;
            for (EffectInstance eff : this.effects) {
                ++affecdted;
                if (livingEntity.func_70644_a(eff.func_188419_a())) {
                    livingEntity.func_70660_b(eff.func_188419_a()).func_199308_a(eff);
                    continue;
                }
                livingEntity.func_195064_c(new EffectInstance(eff.func_188419_a(), 400, eff.func_76458_c(), true, showParticles));
            }
        }
        return affecdted;
    }

    private boolean isPotionValid(EffectInstance eff) {
        return eff.func_188419_a().func_188408_i() && !eff.func_188419_a().func_76403_b();
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case ENTITYTYPE: {
                return this.entityFilter.ordinal();
            }
            case RANGE: {
                return this.radius;
            }
        }
        return -1;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case ENTITYTYPE: {
                this.entityFilter = EntityFilterType.values()[value %= EntityFilterType.values().length];
                break;
            }
            case RANGE: {
                this.radius = value > 64 ? 64 : Math.min(value, 64);
            }
        }
    }

    public List<String> getPotionDisplay() {
        ArrayList<String> list = new ArrayList<String>();
        for (EffectInstance eff : this.effects) {
            list.add(eff.func_76453_d());
        }
        return list;
    }

    public String getTimerDisplay() {
        if (this.effects.size() == 0) {
            return "cyclic.gui.empty";
        }
        return this.getTimerSeconds() + " seconds";
    }

    private int getTimerSeconds() {
        return this.timer / 20;
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        RANGE,
        ENTITYTYPE;

    }
}

