/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.breaker;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.breaker.ContainerBreaker;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileBreaker
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    static final int MAX = 64000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TileBreaker() {
        super(TileRegistry.breakerTile);
    }

    public void func_73660_a() {
        BlockPos target;
        BlockState state;
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        Integer cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        this.setLitProperty(true);
        this.energy.extractEnergy(cost, false);
        if (this.field_145850_b.field_73012_v.nextDouble() < 0.3 && (state = this.field_145850_b.func_180495_p(target = this.field_174879_c.func_177972_a(this.getCurrentFacing()))).func_185887_b((IBlockReader)this.field_145850_b, target) >= 0.0f) {
            this.field_145850_b.func_175655_b(target, true);
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerBreaker(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return 0;
    }

    public int getEnergyMax() {
        return 64000;
    }

    static enum Fields {
        REDSTONE;

    }
}

