/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.dropper;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.dropper.ContainerDropper;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileDropper
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    static final int MAX = 64000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private ItemStackHandler inventory = new ItemStackHandler(1);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int dropCount = 1;
    private int delay = 10;
    private int hOffset = 0;

    public TileDropper() {
        super(TileRegistry.dropper);
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        --this.timer;
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.timer > 0) {
            return;
        }
        this.timer = this.delay;
        ItemStack dropMe = this.inventory.getStackInSlot(0).func_77946_l();
        BlockPos target = this.getTargetPos();
        int amtDrop = Math.min(this.dropCount, dropMe.func_190916_E());
        if (amtDrop > 0) {
            this.energy.extractEnergy(cost, false);
            dropMe.func_190920_e(amtDrop);
            UtilItemStack.dropItemStackMotionless(this.field_145850_b, target, dropMe);
            this.inventory.getStackInSlot(0).func_190918_g(amtDrop);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerDropper(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        this.delay = tag.func_74762_e("delay");
        this.dropCount = tag.func_74762_e("dropCount");
        this.hOffset = tag.func_74762_e("hOffset");
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("dropCount", this.dropCount);
        tag.func_74768_a("hOffset", this.hOffset);
        return super.func_189515_b(tag);
    }

    private BlockPos getTargetPos() {
        BlockPos target = this.getCurrentFacingPos().func_177967_a(this.getCurrentFacing(), this.hOffset);
        return target;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case DELAY: {
                return this.delay;
            }
            case DROPCOUNT: {
                return this.dropCount;
            }
            case OFFSET: {
                return this.hOffset;
            }
            case RENDER: {
                return this.render;
            }
        }
        return -1;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case DELAY: {
                this.delay = Math.max(0, value);
                break;
            }
            case DROPCOUNT: {
                this.dropCount = Math.max(1, value);
                break;
            }
            case OFFSET: {
                this.hOffset = Math.max(0, value);
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    public List<BlockPos> getShape() {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        shape.add(this.getTargetPos());
        return shape;
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        DROPCOUNT,
        DELAY,
        OFFSET,
        RENDER;

    }
}

