/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.endershelf.EnderShelfHelper;
import com.lothrazar.cyclic.block.endershelf.EnderShelfRenderer;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilBlockstates;
import com.lothrazar.cyclic.util.UtilEnchant;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockEnderShelf
extends BlockBase {
    public static BooleanProperty IS_CONTROLLER = BooleanProperty.func_177716_a((String)"is_controller");

    public BlockEnderShelf(AbstractBlock.Properties properties) {
        this(properties, false);
    }

    public BlockEnderShelf(AbstractBlock.Properties properties, boolean isController) {
        super(properties.func_200943_b(1.8f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)IS_CONTROLLER, (Comparable)Boolean.valueOf(isController)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
        ClientRegistry.bindTileEntityRenderer(TileRegistry.ender_shelf, EnderShelfRenderer::new);
        ClientRegistry.bindTileEntityRenderer(TileRegistry.ender_controller, EnderShelfRenderer::new);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J}).func_206894_a(new Property[]{IS_CONTROLLER});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEnderShelf();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)UtilBlockstates.getFacingFromEntityHorizontal(pos, entity)), 2);
            if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEnderShelf) {
                TileEnderShelf shelf = (TileEnderShelf)world.func_175625_s(pos);
                BlockPos controllerPos = null;
                TileEnderShelf controller = null;
                if (EnderShelfHelper.isController(state)) {
                    shelf.setControllerLocation(pos);
                    controllerPos = pos;
                    controller = shelf;
                } else if (EnderShelfHelper.isShelf(state)) {
                    controllerPos = EnderShelfHelper.findConnectedController(world, pos);
                    shelf.setControllerLocation(controllerPos);
                    controller = this.getTileEntity(world, controllerPos);
                }
                if (controllerPos != null && controller != null) {
                    Set<BlockPos> shelves = EnderShelfHelper.findConnectedShelves(world, controllerPos);
                    controller.setShelves(shelves);
                }
            }
        }
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IItemHandler items;
        TileEntity tileentity;
        boolean isCurrentlyShelf = EnderShelfHelper.isShelf(state);
        boolean isNewShelf = EnderShelfHelper.isShelf(newState);
        TileEnderShelf te = this.getTileEntity(worldIn, pos);
        if (isCurrentlyShelf && !isNewShelf && te != null && te.getControllerLocation() != null) {
            te.setShelves(EnderShelfHelper.findConnectedShelves(worldIn, pos));
        }
        if (state.func_177230_c() != newState.func_177230_c() && (tileentity = worldIn.func_175625_s(pos)) != null && (items = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack is = items.getStackInSlot(i);
                while (!is.func_190926_b()) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)is.func_77979_a(1));
                }
            }
            worldIn.func_175666_e(pos, (Block)this);
            worldIn.func_175713_t(pos);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184614_ca();
        Direction face = hit.func_216354_b();
        Vector3d hitVec = hit.func_216347_e();
        int slot = this.getSlotFromHitVec(pos, face, hitVec);
        if (world.func_175625_s(pos) instanceof TileEnderShelf) {
            TileEnderShelf shelf = this.getTileEntity(world, pos);
            if (EnderShelfHelper.isShelf(state) && hand == Hand.MAIN_HAND && hit.func_216354_b() == state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
                if (heldItem.func_77973_b() == Items.field_151134_bR) {
                    shelf.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                        if (h.getStackInSlot(slot) == ItemStack.field_190927_a || UtilEnchant.doBookEnchantmentsMatch(h.getStackInSlot(slot), heldItem)) {
                            if (!world.field_72995_K) {
                                h.insertItem(slot, heldItem, false);
                            }
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    });
                } else if (heldItem.func_190926_b()) {
                    shelf.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                        ItemStack retrievedBook = h.extractItem(slot, 1, false);
                        player.func_184611_a(hand, retrievedBook);
                    });
                }
            } else if (EnderShelfHelper.isController(state) && hand == Hand.MAIN_HAND) {
                if (heldItem.func_77973_b() == Items.field_151134_bR) {
                    shelf.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> player.func_184611_a(Hand.MAIN_HAND, h.insertItem(0, heldItem, false)));
                }
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.PASS;
    }

    private int getSlotFromHitVec(BlockPos pos, Direction face, Vector3d hitVec) {
        double normalizedY = hitVec.func_82617_b() - (double)pos.func_177956_o();
        return (int)Math.floor(normalizedY / 0.2);
    }

    public TileEnderShelf getTileEntity(World world, BlockPos pos) {
        if (pos == null) {
            return null;
        }
        BlockState state = world.func_180495_p(pos);
        return EnderShelfHelper.isShelf(state) || EnderShelfHelper.isController(state) ? (TileEnderShelf)world.func_175625_s(pos) : null;
    }
}

