/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.net.PacketTileInventory;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilEnchant;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class EnderShelfItemHandler
extends ItemStackHandler {
    public TileEnderShelf shelf;
    private final boolean fake;

    public EnderShelfItemHandler(TileEnderShelf shelf) {
        super(5);
        this.shelf = shelf;
        this.fake = false;
    }

    public EnderShelfItemHandler(TileEnderShelf shelf, boolean fake) {
        super(5);
        this.shelf = shelf;
        this.fake = fake;
    }

    public ItemStack emptySlot(int slot) {
        ItemStack returnStack = this.getStackInSlot(slot);
        this.stacks.set(slot, (Object)ItemStack.field_190927_a);
        return returnStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.shelf.func_145831_w() == null) {
            return ItemStack.field_190927_a;
        }
        if (!this.fake) {
            ItemStack extracted = super.extractItem(slot, amount, simulate);
            if (!this.shelf.func_145831_w().field_72995_K && !simulate) {
                PacketRegistry.sendToAllClients(this.shelf.func_145831_w(), new PacketTileInventory(this.shelf.func_174877_v(), slot, this.getStackInSlot(slot), PacketTileInventory.TYPE.SET));
            }
            return extracted;
        }
        long rand = (long)(Math.random() * (double)ForgeRegistries.ENCHANTMENTS.getValues().size());
        Enchantment randomEnchant = ForgeRegistries.ENCHANTMENTS.getValues().stream().skip(rand).findAny().orElse(Enchantments.field_185299_g);
        int randLevel = Math.max(randomEnchant.func_77319_d(), (int)(Math.random() * (double)randomEnchant.func_77325_b()));
        EnchantmentData ench = new EnchantmentData(randomEnchant, randLevel);
        return EnchantedBookItem.func_92111_a((EnchantmentData)ench);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() == Items.field_151134_bR && EnchantedBookItem.func_92110_g((ItemStack)stack).size() == 1 && (this.getStackInSlot(slot).func_190926_b() || UtilEnchant.doBookEnchantmentsMatch(stack, this.getStackInSlot(slot)));
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return 64;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.shelf == null || this.shelf.func_145831_w() == null) {
            return stack;
        }
        ItemStack remaining = super.insertItem(slot, stack, simulate);
        if (!this.shelf.func_145831_w().field_72995_K && !simulate) {
            PacketRegistry.sendToAllClients(this.shelf.func_145831_w(), new PacketTileInventory(this.shelf.func_174877_v(), slot, this.getStackInSlot(slot), PacketTileInventory.TYPE.SET));
        }
        return remaining;
    }

    public int firstSlotWithItem() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }
}

