/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.block.endershelf.EnderControllerItemHandler;
import com.lothrazar.cyclic.block.endershelf.EnderShelfHelper;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.util.UtilRenderText;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.items.CapabilityItemHandler;

public class EnderShelfRenderer
extends TileEntityRenderer<TileEnderShelf> {
    private static final float OFFSET = -0.01f;

    public EnderShelfRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEnderShelf tile, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlayLight) {
        EnderControllerItemHandler h2;
        Direction side = tile.getCurrentFacing();
        UtilRenderText.alignRendering(ms, side);
        if (EnderShelfHelper.isShelf(tile.func_195044_w())) {
            tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    this.renderSlot(i, h.getStackInSlot(i), ms, buffer, light);
                }
            });
        } else if (EnderShelfHelper.isController(tile.func_195044_w()) && (h2 = EnderShelfHelper.getControllerHandler(tile)) != null) {
            int count = tile.getShelves().size();
            String shelves = count == 1 ? " shelf" : " shelves";
            ms.func_227860_a_();
            FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
            double x = 0.09375;
            double y = 0.875;
            float scale = 0.1f;
            ms.func_227861_a_(x, y, (double)1.01f);
            ms.func_227862_a_(0.0625f * scale, -0.0625f * scale, 5.0E-5f);
            fontRenderer.func_228079_a_(count + shelves, 0.0f, 0.0f, 421025, false, ms.func_227866_c_().func_227870_a_(), buffer, false, 0, light);
            ms.func_227865_b_();
        }
    }

    private void renderSlot(int slot, ItemStack itemStack, MatrixStack ms, IRenderTypeBuffer buffer, int light) {
        if (itemStack.func_190926_b()) {
            return;
        }
        ms.func_227860_a_();
        FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
        AtomicReference<String> displayName = new AtomicReference<String>("Nothing");
        String displayCount = "x" + itemStack.func_190916_E();
        displayName.set(itemStack.func_200301_q().getString());
        if (!itemStack.func_190926_b()) {
            Map enchantments = EnchantmentHelper.func_226652_a_((ListNBT)EnchantedBookItem.func_92110_g((ItemStack)itemStack));
            enchantments.forEach((enchantment, level) -> displayName.set(enchantment.func_200305_d(level.intValue()).getString()));
        }
        double x = 0.09375;
        double y = (float)(3 * slot + 2) / 16.0f;
        float scale = 0.1f * this.getScaleFactor(displayName.get());
        ms.func_227861_a_(x, y, (double)1.01f);
        ms.func_227862_a_(0.0625f * scale, -0.0625f * scale, 5.0E-5f);
        fontRenderer.func_228079_a_(displayName.get(), 0.0f, 0.0f, 421025, false, ms.func_227866_c_().func_227870_a_(), buffer, false, 0, light);
        ms.func_227865_b_();
        ms.func_227860_a_();
        scale = 0.1f;
        ms.func_227861_a_(x, y, (double)1.01f);
        ms.func_227862_a_(0.0625f * scale, -0.0625f * scale, 5.0E-5f);
        fontRenderer.func_228079_a_(displayCount, 110.0f, 0.0f, 421025, false, ms.func_227866_c_().func_227870_a_(), buffer, false, 0, light);
        ms.func_227865_b_();
    }

    private float getScaleFactor(String displayName) {
        if (displayName.length() > 18) {
            return 1.0f - 0.027777778f * (float)(displayName.length() - 18);
        }
        return 1.0f;
    }
}

