/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.endershelf.EnderControllerItemHandler;
import com.lothrazar.cyclic.block.endershelf.EnderShelfHelper;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEnderShelf
extends TileEntityBase {
    private final LazyOptional<EnderShelfItemHandler> inventory = LazyOptional.of(() -> new EnderShelfItemHandler(this));
    private final LazyOptional<EnderControllerItemHandler> controllerInventory = LazyOptional.of(() -> new EnderControllerItemHandler(this));
    private BlockPos controllerLocation = null;
    private Set<BlockPos> connectedShelves = new HashSet<BlockPos>();

    public TileEnderShelf() {
        super(TileRegistry.ender_shelf);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public void setControllerLocation(BlockPos pos) {
        this.controllerLocation = pos;
    }

    public BlockPos getControllerLocation() {
        return this.controllerLocation;
    }

    public void setShelves(Set<BlockPos> shelves) {
        this.connectedShelves = shelves;
        this.connectedShelves = this.connectedShelves.stream().sorted(Comparator.comparing(o -> o.func_177951_i((Vector3i)this.field_174879_c))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<BlockPos> getShelves() {
        return this.connectedShelves;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        boolean isController = EnderShelfHelper.isController(this.func_195044_w());
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (isController) {
                return this.controllerInventory.cast();
            }
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.ifPresent(h -> h.deserializeNBT((INBT)tag.func_74775_l("inv")));
        if (tag.func_74764_b("shelves")) {
            ListNBT shelves = tag.func_150295_c("shelves", 10);
            for (int i = 0; i < shelves.size(); ++i) {
                BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)shelves.func_150305_b(i));
                this.connectedShelves.add(pos);
            }
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)h.serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        ListNBT shelves = new ListNBT();
        for (BlockPos pos : this.connectedShelves) {
            shelves.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
        }
        tag.func_218657_a("shelves", (INBT)shelves);
        return super.func_189515_b(tag);
    }
}

