/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.fan;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.fan.ContainerFan;
import com.lothrazar.cyclic.net.PacketPlayerFalldamage;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TileFan
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 64;
    public static final int MIN_SPEED = 1;
    public static final int MAX_SPEED = 20;
    private int range = 7;
    private int speed = 5;

    public TileFan() {
        super(TileRegistry.fantile);
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        this.pushEntities();
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerFan(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public int getRange() {
        return this.range;
    }

    private float getSpeedCalc() {
        return (float)this.speed / 35.0f;
    }

    private int getCurrentRange() {
        Direction facing = this.getCurrentFacing();
        for (int i = 1; i <= this.getRange(); ++i) {
            BlockPos tester = this.func_174877_v().func_177967_a(facing, i);
            if (this.canBlowThrough(tester)) continue;
            return i;
        }
        return this.getRange();
    }

    private boolean canBlowThrough(BlockPos tester) {
        return !this.field_145850_b.func_180495_p(tester).func_200132_m();
    }

    public List<BlockPos> getShape() {
        return UtilShape.line(this.func_174877_v(), this.getCurrentFacing(), this.getCurrentRange());
    }

    private int pushEntities() {
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return 0;
        }
        BlockPos start = shape.get(0);
        BlockPos end = shape.get(shape.size() - 1);
        switch (this.getCurrentFacing().func_176740_k()) {
            case X: {
                end = end.func_177982_a(0, 0, 1);
                end = end.func_177982_a(0, 1, 0);
                break;
            }
            case Z: {
                end = end.func_177982_a(1, 0, 0);
                end = end.func_177982_a(0, 1, 0);
                break;
            }
            case Y: {
                start = start.func_177982_a(1, 0, 0);
                end = end.func_177982_a(0, 0, 1);
            }
        }
        Direction face = this.getCurrentFacing();
        switch (face) {
            case NORTH: {
                start = start.func_177968_d();
                break;
            }
            case SOUTH: {
                end = end.func_177968_d();
                break;
            }
            case EAST: {
                end = end.func_177974_f();
                break;
            }
            case WEST: {
                start = start.func_177974_f();
                break;
            }
            case DOWN: {
                break;
            }
        }
        AxisAlignedBB region = new AxisAlignedBB(start, end);
        List entitiesFound = this.func_145831_w().func_217357_a(Entity.class, region);
        int moved = 0;
        boolean doPush = true;
        int direction = 1;
        float speed = this.getSpeedCalc();
        for (Entity entity : entitiesFound) {
            if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_213453_ef()) continue;
            ++moved;
            double newx = entity.func_213322_ci().func_82615_a();
            double newy = entity.func_213322_ci().func_82617_b();
            double newz = entity.func_213322_ci().func_82616_c();
            switch (face) {
                case NORTH: {
                    direction = !doPush ? 1 : -1;
                    newz += (double)((float)direction * speed);
                    break;
                }
                case SOUTH: {
                    direction = doPush ? 1 : -1;
                    newz += (double)((float)direction * speed);
                    break;
                }
                case EAST: {
                    direction = doPush ? 1 : -1;
                    newx += (double)((float)direction * speed);
                    break;
                }
                case WEST: {
                    direction = !doPush ? 1 : -1;
                    newx += (double)((float)direction * speed);
                    break;
                }
                case DOWN: {
                    direction = !doPush ? 1 : -1;
                    newy += (double)((float)direction * speed);
                    break;
                }
                case UP: {
                    direction = doPush ? 1 : -1;
                    newy += (double)((float)direction * speed);
                }
            }
            entity.func_213293_j(newx, newy, newz);
            if (!this.field_145850_b.field_72995_K || entity.field_70173_aa % 22 != 0 || !(entity instanceof PlayerEntity)) continue;
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketPlayerFalldamage());
        }
        return moved;
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.speed = tag.func_74762_e("speed");
        this.range = tag.func_74762_e("range");
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("speed", this.speed);
        tag.func_74768_a("range", this.range);
        return super.func_189515_b(tag);
    }

    @Override
    public int getField(int f) {
        switch (Fields.values()[f]) {
            case RANGE: {
                return this.range;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SPEED: {
                return this.speed;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        Fields f = Fields.values()[field];
        switch (f) {
            case RANGE: {
                this.range = value;
                if (this.range < 1) {
                    this.range = 1;
                }
                if (this.range <= 64) break;
                this.range = 64;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case SPEED: {
                this.speed = value;
                if (this.speed < 1) {
                    this.speed = 1;
                }
                if (this.speed <= 20) break;
                this.speed = 20;
            }
        }
    }

    static enum Fields {
        REDSTONE,
        RANGE,
        SPEED;

    }
}

