/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.melter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.melter.TileMelter;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeMelter<TileEntityBase>
extends CyclicRecipe {
    private static final Set<String> HASHES = new HashSet<String>();
    public static final Set<RecipeMelter<?>> RECIPES = new HashSet();
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private FluidStack outFluid;
    public static final SerializeMelter SERIALMELTER = new SerializeMelter();

    protected RecipeMelter(ResourceLocation id, Ingredient in, Ingredient inSecond, FluidStack out) {
        super(id);
        this.ingredients.add((Object)in);
        this.ingredients.add((Object)inSecond);
        this.outFluid = out;
    }

    public boolean matches(TileEntityBase inv, World worldIn) {
        try {
            TileMelter tile = (TileMelter)inv;
            return this.matches(tile, 0) && this.matches(tile, 1);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(TileMelter tile, int slot) {
        ItemStack current = tile.getStackInputSlot(slot);
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        for (ItemStack test : ing.func_193365_a()) {
            if (!UtilItemStack.matches(current, test)) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.func_193365_a();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    @Override
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.outFluid.copy();
    }

    public IRecipeType<?> func_222127_g() {
        return CyclicRecipeType.MELTER;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALMELTER;
    }

    private static void addRecipe(RecipeMelter r) {
        ResourceLocation id = r.func_199560_c();
        if (HASHES.contains(id.toString())) {
            ModCyclic.LOGGER.info("Warning: Duplicate melter recipe id " + id.toString());
        } else {
            RECIPES.add(r);
            HASHES.add(id.toString());
            ModCyclic.LOGGER.info("Recipe loaded " + id.toString());
        }
    }

    public static class SerializeMelter
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeMelter<? extends TileEntityBase>> {
        SerializeMelter() {
            this.setRegistryName(new ResourceLocation("cyclic", "melter"));
        }

        public RecipeMelter<? extends TileEntityBase> read(ResourceLocation recipeId, JsonObject json) {
            RecipeMelter r = null;
            try {
                Ingredient inputFirst = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputFirst"));
                Ingredient inputSecond = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputSecond"));
                JsonObject result = json.get("result").getAsJsonObject();
                int count = result.get("count").getAsInt();
                String fluidId = JSONUtils.func_151200_h((JsonObject)result, (String)"fluid");
                ResourceLocation resourceLocation = new ResourceLocation(fluidId);
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
                r = new RecipeMelter(recipeId, inputFirst, inputSecond, new FluidStack(fluid, count));
                RecipeMelter.addRecipe(r);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe" + recipeId, e);
            }
            return r;
        }

        public RecipeMelter read(ResourceLocation recipeId, PacketBuffer buffer) {
            RecipeMelter r = new RecipeMelter(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), Ingredient.func_199566_b((PacketBuffer)buffer), FluidStack.readFromPacket((PacketBuffer)buffer));
            RecipeMelter.addRecipe(r);
            return r;
        }

        public void write(PacketBuffer buffer, RecipeMelter recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            Ingredient one = (Ingredient)recipe.ingredients.get(1);
            zero.func_199564_a(buffer);
            one.func_199564_a(buffer);
            recipe.outFluid.writeToPacket(buffer);
        }
    }
}

