/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.placer;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.placer.ContainerPlacer;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TilePlacer
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    ItemStackHandler inventory = new ItemStackHandler(1);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    static final int MAX = 64000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TilePlacer() {
        super(TileRegistry.placer);
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        Integer cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        this.setLitProperty(true);
        this.energy.extractEnergy(cost, false);
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_190926_b() || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) {
            return;
        }
        Direction dir = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos offset = this.field_174879_c.func_177972_a(dir);
        BlockState state = Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P();
        if (this.field_145850_b.func_175623_d(offset) && this.field_145850_b.func_175656_a(offset, state)) {
            stack.func_190918_g(1);
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerPlacer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return 0;
    }

    static enum Fields {
        REDSTONE;

    }
}

