/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.uncrafter;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.uncrafter.ContainerUncraft;
import com.lothrazar.cyclic.block.uncrafter.UncraftStatusEnum;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileUncraft
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    static final int MAX = 64000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    public static ForgeConfigSpec.BooleanValue IGNORE_NBT;
    public static ForgeConfigSpec.ConfigValue<List<String>> IGNORELIST;
    public static ForgeConfigSpec.ConfigValue<Integer> TIMER;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(17);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private UncraftStatusEnum status = UncraftStatusEnum.EMPTY;

    public TileUncraft() {
        super(TileRegistry.uncrafter);
    }

    public void func_73660_a() {
        this.syncEnergy();
        ItemStack dropMe = this.inventory.getStackInSlot(0).func_77946_l();
        if (dropMe.func_190926_b()) {
            this.status = UncraftStatusEnum.EMPTY;
            return;
        }
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        this.setLitProperty(true);
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_73046_m() == null) {
            return;
        }
        IRecipe<?> match = this.findMatchingRecipe(this.field_145850_b, dropMe);
        if (match != null) {
            this.status = UncraftStatusEnum.MATCH;
            this.uncraftRecipe(match);
            this.energy.extractEnergy(cost, false);
            this.timer = (Integer)TIMER.get();
        }
    }

    public UncraftStatusEnum getStatus() {
        return this.status;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerUncraft(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        this.status = UncraftStatusEnum.values()[tag.func_74762_e("ucstats")];
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("ucstats", this.status.ordinal());
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    private void uncraftRecipe(IRecipe<?> match) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Ingredient ing : match.func_192400_c()) {
            if (ing.func_193365_a().length == 0) continue;
            int index = MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)0, (int)(ing.func_193365_a().length - 1));
            index = 0;
            result.add(ing.func_193365_a()[index]);
        }
        for (ItemStack r : result) {
            if (r.func_190926_b()) continue;
            this.inventory.extractItem(0, match.func_77571_b().func_190916_E(), false);
            for (int i = 1; i < this.inventory.getSlots() && !r.func_190926_b(); ++i) {
                r = this.inventory.insertItem(i, r.func_77946_l(), false);
            }
        }
    }

    public IRecipe<?> findMatchingRecipe(World world, ItemStack dropMe) {
        Collection list = world.func_73046_m().func_199529_aN().func_199510_b();
        for (IRecipe recipe : list) {
            if (recipe.func_222127_g() != IRecipeType.field_222149_a || !this.recipeMatches(dropMe, recipe)) continue;
            return recipe;
        }
        return null;
    }

    private boolean recipeMatches(ItemStack stack, IRecipe<?> recipe) {
        if (stack.func_190926_b() || recipe.func_77571_b().func_190926_b() || recipe.func_77571_b().func_190916_E() > stack.func_190916_E()) {
            this.status = UncraftStatusEnum.NORECIPE;
            return false;
        }
        if (UtilString.isInList((List)IGNORELIST.get(), stack.func_77973_b().getRegistryName())) {
            ModCyclic.LOGGER.info("Uncrafter: blocked by config list " + stack);
            this.status = UncraftStatusEnum.CONFIG;
            return false;
        }
        boolean matches = false;
        if (((Boolean)IGNORE_NBT.get()).booleanValue()) {
            ModCyclic.LOGGER.info("Uncrafter NBT ignored " + stack.func_77978_p());
            matches = stack.func_77973_b() == recipe.func_77571_b().func_77973_b();
        } else {
            boolean bl = matches = stack.func_77973_b() == recipe.func_77571_b().func_77973_b() && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)recipe.func_77571_b());
        }
        if (!matches) {
            this.status = UncraftStatusEnum.NORECIPE;
        }
        return matches;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case STATUS: {
                return this.status.ordinal();
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case STATUS: {
                this.status = UncraftStatusEnum.values()[value];
            }
        }
    }

    static enum Fields {
        REDSTONE,
        STATUS;

    }
}

