/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.workbench;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.workbench.ContainerWorkbench;
import com.lothrazar.cyclic.registry.TileRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileWorkbench
extends TileEntityBase
implements INamedContainerProvider {
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> new ItemStackHandler(9));
    private LazyOptional<IItemHandler> output = LazyOptional.of(() -> new ItemStackHandler(1));

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerWorkbench(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public TileWorkbench() {
        super(TileRegistry.workbench);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nonnull ItemHandlers handler) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (handler == ItemHandlers.GRID) {
                return this.inventory.cast();
            }
            if (handler == ItemHandlers.OUTPUT) {
                return this.output.cast();
            }
        }
        return super.getCapability(cap, Direction.NORTH);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public static enum ItemHandlers {
        GRID,
        OUTPUT;

    }
}

