/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.melter.RecipeMelter;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.util.ResourceLocation;

public class MelterRecipeCategory
implements IRecipeCategory<RecipeMelter> {
    static ResourceLocation ID = new ResourceLocation(CyclicRecipeType.MELTER.toString());
    private IDrawable gui;
    private IDrawable icon;

    public MelterRecipeCategory(IGuiHelper helper) {
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/melter_recipe.png"), 0, 0, 169, 69).setTextureSize(169, 69).build();
        this.icon = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/blocks/melter.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public String getTitle() {
        return UtilChat.lang(BlockRegistry.melter.func_149739_a());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public Class<? extends RecipeMelter> getRecipeClass() {
        return RecipeMelter.class;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public void setIngredients(RecipeMelter recipe, IIngredients ingredients) {
        ArrayList in = new ArrayList();
        ArrayList stuff = new ArrayList();
        Collections.addAll(stuff, recipe.ingredientAt(0));
        in.add(stuff);
        stuff = new ArrayList();
        Collections.addAll(stuff, recipe.ingredientAt(1));
        in.add(stuff);
        ingredients.setInputLists(VanillaTypes.ITEM, in);
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getRecipeFluid());
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipeMelter recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 3, 18);
        guiItemStacks.init(1, true, 21, 18);
        guiItemStacks.init(2, true, 41, 18);
        guiItemStacks.init(3, true, 3, 120);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List input = (List)inputs.get(0);
        if (input != null && !input.isEmpty()) {
            guiItemStacks.set(0, input);
        }
        if ((input = (List)inputs.get(1)) != null && !input.isEmpty()) {
            guiItemStacks.set(1, input);
        }
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getRecipeFluid());
        recipeLayout.getFluidStacks().init(0, true, 140, 19, 16, 16, 1000, false, null);
        recipeLayout.getFluidStacks().set(0, recipe.getRecipeFluid());
    }
}

