/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.ConfigRegistry;
import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilNBT;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantBeheading
extends EnchantBase {
    private static final int percentDrop = 20;
    private static final int percentPerLevel = 25;
    public static final String ID = "beheading";
    public static ForgeConfigSpec.BooleanValue CFG;

    public EnchantBeheading(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 3;
    }

    private int percentForLevel(int level) {
        return 20 + (level - 1) * 25;
    }

    @SubscribeEvent
    public void onEntityKill(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity attacker = (PlayerEntity)event.getSource().func_76346_g();
            int level = this.getCurrentLevelTool((LivingEntity)attacker);
            if (level <= 0) {
                return;
            }
            World world = attacker.field_70170_p;
            if (MathHelper.func_76136_a((Random)world.field_73012_v, (int)0, (int)100) > this.percentForLevel(level)) {
                return;
            }
            LivingEntity target = (LivingEntity)event.getEntity();
            if (target == null) {
                return;
            }
            BlockPos pos = target.func_233580_cy_();
            if (target instanceof PlayerEntity) {
                UtilItemStack.drop(world, pos, UtilNBT.buildNamedPlayerSkull((PlayerEntity)target));
                return;
            }
            String key = target.func_200600_R().getRegistryName().toString();
            Map<String, String> mappedBeheading = ConfigRegistry.getMappedBeheading();
            if (mappedBeheading.containsKey(key)) {
                UtilItemStack.drop(world, pos, UtilNBT.buildNamedPlayerSkull(mappedBeheading.get(key)));
            } else if (target.func_200600_R() == EntityType.field_200802_p) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196151_dA));
            } else if (target.func_200600_R() == EntityType.field_200797_k) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196185_dy));
            } else if (target.func_200600_R() == EntityType.field_200725_aD) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196186_dz));
            } else if (target.func_200600_R() == EntityType.field_200741_ag) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196182_dv));
            } else if (target.func_200600_R() == EntityType.field_200722_aA) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196183_dw));
            } else if (target.func_200600_R() == EntityType.field_200760_az) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)Items.field_196183_dw, level));
            }
        }
    }
}

