/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.EnchantBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantExcavation
extends EnchantBase {
    private static final int POWER_PER_LEVEL = 8;
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "excavate";
    private static final Direction[] VALUES;

    public EnchantExcavation(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 5;
    }

    public boolean func_92089_a(ItemStack stack) {
        return super.func_92089_a(stack) || stack.func_77973_b() instanceof ShearsItem;
    }

    private int getHarvestMax(int level) {
        return (level + 2) * 8 + 10;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        if (player.field_184622_au == null || world.func_201670_d()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState eventState = event.getState();
        Block block = eventState.func_177230_c();
        ItemStack stackHarvestingWith = player.func_184586_b(player.field_184622_au);
        int level = this.getCurrentLevelTool(stackHarvestingWith);
        if (level <= 0) {
            return;
        }
        if (ForgeHooks.canHarvestBlock((BlockState)eventState, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos)) {
            int harvested = this.harvestSurrounding((World)world, player, pos, block, 1, level, player.field_184622_au);
            if (harvested > 0) {
                player.func_184586_b(player.field_184622_au).func_96631_a(1, world.func_201674_k(), null);
            }
        } else {
            ModCyclic.LOGGER.info(stackHarvestingWith + "  TOOL NOT EFFECTIVE ON " + world.func_180495_p(pos));
        }
    }

    private int harvestSurrounding(World world, PlayerEntity player, BlockPos posIn, Block block, int totalBroken, int level, Hand swingingHand) {
        if (totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) {
            return totalBroken;
        }
        HashSet<BlockPos> wasHarvested = new HashSet<BlockPos>();
        Set<BlockPos> theFuture = this.getMatchingSurrounding(world, posIn, block);
        for (BlockPos targetPos : theFuture) {
            int silklevel;
            int bonusLevel;
            int exp;
            BlockState targetState = world.func_180495_p(targetPos);
            if (world.func_175623_d(targetPos) || !player.func_175142_cm() || !player.func_234569_d_(targetState) || totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b() || !ForgeHooks.canHarvestBlock((BlockState)targetState, (PlayerEntity)player, (IBlockReader)world, (BlockPos)targetPos)) continue;
            if (world instanceof ServerWorld) {
                Block.func_220059_a((BlockState)targetState, (IWorld)world, (BlockPos)targetPos, (TileEntity)world.func_175625_s(targetPos));
            }
            if ((exp = targetState.getExpDrop((IWorldReader)world, targetPos, bonusLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca()), silklevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()))) > 0 && world instanceof ServerWorld) {
                block.func_180637_b((ServerWorld)world, targetPos, exp);
            }
            world.func_175655_b(targetPos, false);
            wasHarvested.add(targetPos);
            ++totalBroken;
        }
        if (wasHarvested.size() == 0) {
            return totalBroken;
        }
        for (BlockPos targetPos : theFuture) {
            if (totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) break;
            totalBroken += this.harvestSurrounding(world, player, targetPos, block, totalBroken, level, swingingHand);
        }
        return totalBroken;
    }

    private Set<BlockPos> getMatchingSurrounding(World world, BlockPos start, Block blockIn) {
        HashSet<BlockPos> list = new HashSet<BlockPos>();
        List<Direction> targetFaces = Arrays.asList(VALUES);
        try {
            Collections.shuffle(targetFaces);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Direction fac : targetFaces) {
            Block target = world.func_180495_p(start.func_177972_a(fac)).func_177230_c();
            if (target != blockIn) continue;
            list.add(start.func_177972_a(fac));
        }
        return list;
    }

    static {
        VALUES = Direction.values();
    }
}

