/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.fluid.block;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class SlimeFluidBlock
extends FlowingFluidBlock {
    VoxelShape[] shapes = new VoxelShape[16];

    public SlimeFluidBlock(Supplier<? extends FlowingFluid> supplier, AbstractBlock.Properties props) {
        super(supplier, props);
        int max = 15;
        float offset = 0.875f;
        for (int i = 0; i <= max; ++i) {
            this.shapes[i] = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)(offset - (float)i / 8.0f), 1.0));
        }
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[(Integer)state.func_177229_b((Property)field_176367_b)];
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.shapes[(Integer)state.func_177229_b((Property)field_176367_b)];
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.func_226272_bl_()) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        } else {
            entityIn.func_225503_b_(fallDistance, 0.0f);
        }
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            this.collision(entityIn);
        }
    }

    private void collision(Entity entity) {
        Vector3d vec3d = entity.func_213322_ci();
        if (vec3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vec3d.field_72450_a, -vec3d.field_72448_b * d0, vec3d.field_72449_c);
        }
    }

    public static class Source
    extends ForgeFlowingFluid.Source {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int func_185698_b(IWorldReader worldIn) {
            return 1;
        }

        public int func_204528_b(IWorldReader worldIn) {
            return 6;
        }
    }

    public static class Flowing
    extends ForgeFlowingFluid.Flowing {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int func_185698_b(IWorldReader worldIn) {
            return 1;
        }

        public int func_204528_b(IWorldReader worldIn) {
            return 2;
        }
    }
}

