/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AntimatterEvaporatorWandItem
extends ItemBase {
    private static final int SIZE = 4;
    private static final String NBT_MODE = "mode";
    public static final int COOLDOWN = 15;
    private static final List<Fluid> VALID_WATER = new ArrayList<Fluid>();
    private static final List<Fluid> VALID_LAVA = new ArrayList<Fluid>();

    public AntimatterEvaporatorWandItem(Item.Properties properties) {
        super(properties);
        VALID_WATER.add((Fluid)Fluids.field_204546_a);
        VALID_WATER.add((Fluid)Fluids.field_207212_b);
        VALID_LAVA.add((Fluid)Fluids.field_204547_b);
        VALID_LAVA.add((Fluid)Fluids.field_207213_d);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        Direction face = context.func_196000_l();
        Mode fluidMode = Mode.values()[context.func_195996_i().func_196082_o().func_74762_e(NBT_MODE)];
        List<BlockPos> area = UtilShape.cubeSquareBase(pos.func_177972_a(face), 4, 1);
        List<Fluid> theList = fluidMode == Mode.WATER ? VALID_WATER : (fluidMode == Mode.LAVA ? VALID_LAVA : null);
        AtomicBoolean removed = new AtomicBoolean(false);
        if (theList != null) {
            area.stream().filter(pos2 -> theList.contains(world.func_204610_c(pos2).func_206886_c())).forEach(pos3 -> {
                this.removeLiquid(world, (BlockPos)pos3);
                removed.set(true);
            });
        } else {
            area.stream().filter(pos2 -> !world.func_204610_c(pos2).func_206888_e()).forEach(pos3 -> {
                this.removeLiquid(world, (BlockPos)pos3);
                removed.set(true);
            });
        }
        if (removed.get()) {
            PlayerEntity player = context.func_195999_j();
            player.func_184609_a(context.func_221531_n());
            context.func_195996_i().func_222118_a(1, (LivingEntity)player, e -> {});
            if (world.field_72995_K) {
                UtilSound.playSound(pos, SoundEvents.field_187630_M);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void removeLiquid(World world, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)AntimatterEvaporatorWandItem.getModeTooltip(stack).func_240699_a_(TextFormatting.AQUA));
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        stack.func_196082_o().func_74768_a(NBT_MODE, Mode.WATER.ordinal());
        super.func_77622_d(stack, worldIn, playerIn);
    }

    private static TranslationTextComponent getModeTooltip(ItemStack stack) {
        Mode mode = Mode.values()[stack.func_196082_o().func_74762_e(NBT_MODE)];
        return new TranslationTextComponent("item.cyclic.antimatter_wand.tooltip0", new Object[]{new TranslationTextComponent(String.format("item.cyclic.antimatter_wand.mode.%s", mode.func_176610_l()))});
    }

    public static void toggleMode(PlayerEntity player, ItemStack stack) {
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        Mode mode = Mode.values()[stack.func_196082_o().func_74762_e(NBT_MODE)];
        stack.func_196082_o().func_74768_a(NBT_MODE, mode.getNext().ordinal());
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 15);
        if (player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)AntimatterEvaporatorWandItem.getModeTooltip(stack), true);
            UtilSound.playSound((LivingEntity)player, SoundRegistry.tool_mode);
        }
    }

    public static enum Mode implements IStringSerializable
    {
        WATER,
        LAVA,
        GENERIC;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public Mode getNext() {
            switch (this) {
                case WATER: {
                    return LAVA;
                }
                case LAVA: {
                    return GENERIC;
                }
                case GENERIC: {
                    return WATER;
                }
            }
            return WATER;
        }
    }
}

