/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilParticle;
import com.lothrazar.cyclic.util.UtilSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class TeleporterWandItem
extends ItemBase {
    private static final int TICK_REPAIR = 4;
    private static final int TICKS_USING = 93000;
    public static ForgeConfigSpec.IntValue RANGE;

    public TeleporterWandItem(Item.Properties properties) {
        super(properties);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 93000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity && stack.func_77951_h() && stack.func_77952_i() >= 4) {
            this.tryRepairWith(stack, (PlayerEntity)entityIn, Items.field_151079_bi);
        }
    }

    @Override
    public void tryRepairWith(ItemStack stackToRepair, PlayerEntity player, Item target) {
        ItemStack pearls;
        if (stackToRepair.func_77951_h() && !(pearls = this.findAmmo(player, target)).func_190926_b()) {
            pearls.func_190918_g(1);
            UtilItemStack.repairItem(stackToRepair, 4);
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int chargeTimer) {
        PlayerEntity player;
        RayTraceResult trace;
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        float percentageCharged = this.getChargedPercent(stack, chargeTimer);
        if ((double)percentageCharged >= 0.98 && (trace = (player = (PlayerEntity)entity).func_213324_a((double)((Integer)RANGE.get()).intValue(), 0.0f, true)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)trace;
            Direction face = blockRayTraceResult.func_216354_b();
            BlockPos newPos = blockRayTraceResult.func_216350_a().func_177972_a(face);
            BlockPos oldPos = player.func_233580_cy_();
            if (UtilEntity.enderTeleportEvent((LivingEntity)player, world, newPos)) {
                UtilItemStack.damageItem(player, stack);
                if (world.field_72995_K) {
                    UtilParticle.spawnParticleBeam(world, (IParticleData)ParticleTypes.field_197599_J, oldPos, newPos, (Integer)RANGE.get());
                    UtilSound.playSound((LivingEntity)player, SoundEvents.field_187534_aX);
                }
            }
        }
    }
}

