/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.bauble;

import com.lothrazar.cyclic.base.IHasClickToggle;
import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AutoCaveTorchItem
extends ItemBase
implements IHasClickToggle {
    private static final int TICK_DELAY = 2;
    public static final int LIGHT_LIMIT = 9;
    private static final int MAX_DISTANCE_SQ = (int)Math.pow(16.0, 2.0);
    private static final int MAX_LIST_SIZE = 200;
    private int timer = 0;
    private boolean ticking = false;
    private LinkedHashSet<BlockPos> blockHashList = new LinkedHashSet();

    public AutoCaveTorchItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.isOn(stack)) {
            return;
        }
        if (!(entityIn instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        if (player.func_175149_v()) {
            return;
        }
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            stack.func_196085_b(stack.func_77958_k());
            return;
        }
        --this.timer;
        if (this.timer <= 0 && !this.ticking) {
            Iterator iter;
            this.ticking = true;
            BlockPos pos = entityIn.func_233580_cy_();
            if (world.func_217298_h(pos) <= 9) {
                this.blockHashList.addAll(UtilShape.caveInterior(world, pos, player.func_174811_aO(), 100));
                this.blockHashList.removeIf(blockPos -> blockPos != null && player != null && player.func_70092_e((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()) > (double)MAX_DISTANCE_SQ);
                if (this.blockHashList.size() > 200) {
                    int i = this.blockHashList.size();
                    iter = this.blockHashList.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        iter.remove();
                        if (--i > 200) continue;
                    }
                }
            }
            iter = this.blockHashList.iterator();
            while (iter.hasNext()) {
                BlockPos testPos = (BlockPos)iter.next();
                if (!this.shouldPlaceTorch(world, testPos)) continue;
                if (UtilPlaceBlocks.placeTorchSafely(world, testPos)) {
                    UtilItemStack.damageItem(player, stack);
                }
                iter.remove();
                this.timer = 2;
                break;
            }
            this.ticking = false;
        }
        if (!this.ticking) {
            this.tryRepairWith(stack, player, Blocks.field_150478_aa.func_199767_j());
        }
    }

    private boolean shouldPlaceTorch(World world, BlockPos pos) {
        return world.func_201696_r(pos) <= 9 && world.func_175623_d(pos);
    }

    @Override
    public void toggle(PlayerEntity player, ItemStack held) {
        CompoundNBT tag = held.func_196082_o();
        tag.func_74768_a("onoff", (tag.func_74762_e("onoff") + 1) % 2);
        held.func_77982_d(tag);
    }

    @Override
    public boolean isOn(ItemStack held) {
        return held.func_196082_o().func_74762_e("onoff") == 0;
    }
}

