/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.datacard;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.data.RelativeShape;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilPlayer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShapeCard
extends ItemBase {
    public static final String VALID_SHAPE = "cyclic-shape";

    public ShapeCard(Item.Properties properties) {
        super(properties);
    }

    public static void setBlockState(ItemStack wand, BlockState target) {
        CompoundNBT encoded = NBTUtil.func_190009_a((BlockState)target);
        wand.func_196082_o().func_218657_a("blockstate", (INBT)encoded);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        RelativeShape shape = RelativeShape.read(stack);
        if (shape != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".count" + shape.getCount()));
            BlockState target = BuilderActionType.getBlockState(stack);
            String block = "scepter.cyclic.nothing";
            if (target != null) {
                block = target.func_177230_c().func_149739_a();
            }
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.AQUA + UtilChat.lang(block)));
            if (!flagIn.func_194127_a()) return;
        }
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
        t.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RelativeShape shape = RelativeShape.read(stack);
        if (shape != null) {
            BlockState targetState = BuilderActionType.getBlockState(stack);
            if (targetState != null) {
                BlockPos centerPos = player.func_233580_cy_();
                BlockPos posBuild = null;
                for (BlockPos s : shape.getShape()) {
                    posBuild = centerPos.func_177971_a((Vector3i)s);
                    if (World.func_189509_E((BlockPos)posBuild) || !world.func_175623_d(posBuild)) continue;
                    int slot = -1;
                    if (!player.func_184812_l_() && (slot = UtilPlayer.getFirstSlotWithBlock(player, targetState)) < 0) {
                        UtilChat.sendStatusMessage(player, "item.cyclic.shape_data.empty");
                        break;
                    }
                    if (!world.func_180501_a(posBuild, targetState, 1)) continue;
                    UtilPlayer.decrStackSize(player, slot);
                }
            } else {
                UtilChat.sendStatusMessage(player, "item.cyclic.shape_data.state");
            }
        } else {
            UtilChat.sendStatusMessage(player, "item.cyclic.shape_data.nothing");
        }
        player.func_184609_a(hand);
        return super.func_77659_a(world, player, hand);
    }
}

