/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTileString
extends PacketBase {
    private int field;
    private String value;
    private BlockPos pos;

    public PacketTileString(int field, String value, BlockPos pos) {
        this.field = field;
        this.value = value;
        this.pos = pos;
    }

    public PacketTileString() {
    }

    public static void handle(PacketTileString message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.func_130014_f_();
            TileEntity tile = world.func_175625_s(message.pos);
            if (tile instanceof TileEntityBase) {
                TileEntityBase base = (TileEntityBase)tile;
                base.setFieldString(message.field, message.value);
            }
        });
        message.done(ctx);
    }

    public static PacketTileString decode(PacketBuffer buf) {
        PacketTileString p = new PacketTileString();
        p.field = buf.readInt();
        CompoundNBT tags = buf.func_150793_b();
        p.pos = new BlockPos(tags.func_74762_e("x"), tags.func_74762_e("y"), tags.func_74762_e("z"));
        p.value = buf.func_150789_c(Short.MAX_VALUE);
        return p;
    }

    public static void encode(PacketTileString msg, PacketBuffer buf) {
        buf.writeInt(msg.field);
        CompoundNBT tags = new CompoundNBT();
        tags.func_74768_a("x", msg.pos.func_177958_n());
        tags.func_74768_a("y", msg.pos.func_177956_o());
        tags.func_74768_a("z", msg.pos.func_177952_p());
        buf.func_150786_a(tags);
        buf.func_180714_a(msg.value);
    }
}

