/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.registry;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.item.storagebag.StorageBagItem;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ClientRegistry {
    public static void setup() {
        for (BlockBase b : BlockRegistry.blocks) {
            b.registerClient();
        }
        for (ItemBase i : ItemRegistry.items) {
            i.registerClient();
        }
        ClientRegistry.initColours();
    }

    private static void initColours() {
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            if (stack.func_77973_b() == ItemRegistry.storage_bag) {
                if (tintIndex == 0) {
                    return -1;
                }
                int c = StorageBagItem.getColour(stack);
                return c;
            }
            if (stack.func_77973_b() == ItemRegistry.mob_container && stack.func_77942_o() && tintIndex > 0) {
                EntityType thing = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("cyclic:magicnet_id")));
                for (SpawnEggItem spawneggitem : SpawnEggItem.func_195985_g()) {
                    if (spawneggitem.func_208076_b(null) != thing) continue;
                    return spawneggitem.func_195983_a(tintIndex - 1);
                }
            }
            return -1;
        }, new IItemProvider[]{ItemRegistry.mob_container, ItemRegistry.storage_bag});
    }
}

