/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.ToolsLang;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMekanismShield
extends ShieldItem
implements IHasRepairType {
    private final BaseMekanismMaterial material;

    public ItemMekanismShield(BaseMekanismMaterial material, Item.Properties properties) {
        super(properties.func_200918_c(material.getShieldDurability()));
        this.material = material;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)ToolsLang.HP.translate(new Object[]{stack.func_77958_k() - stack.func_77952_i()}));
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.material.func_200898_c();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getShieldDurability();
    }

    public boolean func_77645_m() {
        return this.material.getShieldDurability() > 0;
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return this.getRepairMaterial().test(repair);
    }

    public boolean isShield(ItemStack stack, @Nullable LivingEntity entity) {
        return true;
    }

    public int func_77619_b() {
        return this.material.func_200900_a();
    }
}

