/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.command;

import codechicken.chunkloader.handler.ChickenChunksConfig;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;

public class ChickenChunksCommand {
    private static final String RESTRICTIONS_RESET_FOR = "chickenchunks:commands.restrictions.player.reset";
    private static final String OFFLINE_ENABLE_FOR = "chickenchunks:commands.restrictions.player.offline.enable";
    private static final String OFFLINE_DISABLE_FOR = "chickenchunks:commands.restrictions.player.offline.disable";
    private static final String OFFLINE_RESET_FOR = "chickenchunks:commands.restrictions.player.offline.reset";
    private static final String TIMEOUT_SET_FOR = "chickenchunks:commands.restrictions.player.timeout.set";
    private static final String TIMEOUT_RESET_FOR = "chickenchunks:commands.restrictions.player.timeout.reset";
    private static final String ALLOWED_CHUNKS_SET_FOR = "chickenchunks:commands.restrictions.player.allowed_chunks.set";
    private static final String ALLOWED_CHUNKS_RESET_FOR = "chickenchunks:commands.restrictions.player.allowed_chunks.reset";
    private static final String CHUNKS_PER_LOADER_SET_FOR = "chickenchunks:commands.restrictions.player.chunks_per_loader.set";
    private static final String CHUNKS_PER_LOADER_RESET_FOR = "chickenchunks:commands.restrictions.player.chunks_per_loader.reset";

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ChickenChunksCommand::onRegisterCommands);
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"chickenchunks").requires(e -> e.func_197034_c(4))).then(Commands.func_197057_a((String)"restrict").then(Commands.func_197057_a((String)"player").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)GameProfileArgument.func_197108_a()).then(Commands.func_197057_a((String)"reset").executes(ChickenChunksCommand::resetRestrictions))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"allow_offline").then(Commands.func_197057_a((String)"toggle").executes(ChickenChunksCommand::toggleOfflineFor))).then(Commands.func_197057_a((String)"enable").executes(ChickenChunksCommand::enableOfflineFor))).then(Commands.func_197057_a((String)"disable").executes(ChickenChunksCommand::disableOfflineFor))).then(Commands.func_197057_a((String)"reset").executes(ChickenChunksCommand::resetOfflineFor)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"offline_timeout").then(Commands.func_197056_a((String)"timeout", (ArgumentType)IntegerArgumentType.integer()).executes(ChickenChunksCommand::setTimeoutFor))).then(Commands.func_197057_a((String)"reset").executes(ChickenChunksCommand::resetTimeoutFor)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"allowed_chunks").then(Commands.func_197056_a((String)"allowed_chunks", (ArgumentType)IntegerArgumentType.integer()).executes(ChickenChunksCommand::setAllowedChunksFor))).then(Commands.func_197057_a((String)"reset").executes(ChickenChunksCommand::resetAllowedChunksFor)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"chunks_per_loader").then(Commands.func_197056_a((String)"chunks_per_loader", (ArgumentType)IntegerArgumentType.integer()).executes(ChickenChunksCommand::setChunksPerLoaderFor))).then(Commands.func_197057_a((String)"reset").executes(ChickenChunksCommand::resetChunksPerLoaderFor)))))));
    }

    private static int resetRestrictions(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.resetRestrictions(profile.getId());
            src.func_197030_a((ITextComponent)new TranslationTextComponent(RESTRICTIONS_RESET_FOR, new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static int toggleOfflineFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            boolean state = !restrictions.canLoadOffline();
            restrictions.setAllowOffline(state);
            src.func_197030_a((ITextComponent)new TranslationTextComponent(state ? OFFLINE_ENABLE_FOR : OFFLINE_DISABLE_FOR, new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static int enableOfflineFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        return ChickenChunksCommand.setOfflineFor(ctx, true);
    }

    private static int disableOfflineFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        return ChickenChunksCommand.setOfflineFor(ctx, false);
    }

    private static int setOfflineFor(CommandContext<CommandSource> ctx, boolean state) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setAllowOffline(state);
            src.func_197030_a((ITextComponent)new TranslationTextComponent(state ? OFFLINE_ENABLE_FOR : OFFLINE_DISABLE_FOR, new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static int resetOfflineFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remAllowOffline();
            src.func_197030_a((ITextComponent)new TranslationTextComponent(OFFLINE_RESET_FOR, new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    public static int setTimeoutFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        int timeout = IntegerArgumentType.getInteger(ctx, (String)"timeout");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setOfflineTimeout(timeout);
            src.func_197030_a((ITextComponent)new TranslationTextComponent(TIMEOUT_SET_FOR, new Object[]{profile.getName(), timeout}), true);
        }
        return profiles.size();
    }

    private static int resetTimeoutFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remOfflineTimeout();
            src.func_197030_a((ITextComponent)new TranslationTextComponent(TIMEOUT_RESET_FOR, new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    public static int setAllowedChunksFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"allowed_chunks");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setTotalAllowedChunks(chunks);
            src.func_197030_a((ITextComponent)new TranslationTextComponent(ALLOWED_CHUNKS_SET_FOR, new Object[]{profile.getName(), chunks}), true);
        }
        return profiles.size();
    }

    private static int resetAllowedChunksFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remTotalAllowedChunks();
            src.func_197030_a((ITextComponent)new TranslationTextComponent(ALLOWED_CHUNKS_RESET_FOR, new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    public static int setChunksPerLoaderFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"chunks_per_loader");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setChunksPerLoader(chunks);
            src.func_197030_a((ITextComponent)new TranslationTextComponent(CHUNKS_PER_LOADER_SET_FOR, new Object[]{profile.getName(), chunks}), true);
        }
        return profiles.size();
    }

    private static int resetChunksPerLoaderFor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        Collection profiles = GameProfileArgument.func_197109_a(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remChunksPerLoader();
            src.func_197030_a((ITextComponent)new TranslationTextComponent(CHUNKS_PER_LOADER_RESET_FOR, new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static ChickenChunksConfig.Restrictions getPlayerRestrictions(UUID player) {
        return ChickenChunksConfig.getOrCreateRestrictions(player);
    }
}

