/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.exchange;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackHandlerEx;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.registry.ConfigRegistry;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class ExchangeItemStackHandler
extends ItemStackHandlerEx {
    private TileMain tileMain;

    public ExchangeItemStackHandler() {
        super((Integer)ConfigRegistry.EXCHANGEBUFFER.get());
        StorageNetwork.log("ConfigRegistry.EXCHANGEBUFFER.get()" + ConfigRegistry.EXCHANGEBUFFER.get());
        this.update();
    }

    public void setMain(TileMain main) {
        this.tileMain = main;
        this.update();
    }

    public void update() {
        if (this.tileMain == null) {
            return;
        }
        int i = 0;
        for (ItemStack stack : this.tileMain.getStacks()) {
            if (i >= this.stacks.size()) break;
            this.stacks.set(i, (Object)stack);
            ++i;
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b() || this.tileMain == null || !this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        int remaining = this.tileMain.insertStack(stack, simulate);
        StorageNetwork.log("exchange: insertItem " + stack + " remain " + remaining);
        if (remaining > 0) {
            this.update();
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining);
        }
        this.update();
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.tileMain == null) {
            return ItemStack.field_190927_a;
        }
        ItemStackMatcher matcher = new ItemStackMatcher(this.getStackInSlot(slot));
        ItemStack stack = this.tileMain.request(matcher, amount, simulate);
        this.update();
        StorageNetwork.log("exchange: extractItem; after " + stack);
        return stack;
    }

    protected void onLoad() {
        this.update();
    }
}

