/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.qnb;

import appeng.block.qnb.QnbFormedState;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.core.Api;
import appeng.tile.qnb.QuantumBridgeTileEntity;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

class QnbFormedBakedModel
implements IDynamicBakedModel {
    private static final RenderMaterial TEXTURE_LINK = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/quantum_link"));
    private static final RenderMaterial TEXTURE_RING = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/quantum_ring"));
    private static final RenderMaterial TEXTURE_RING_LIGHT = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/quantum_ring_light"));
    private static final RenderMaterial TEXTURE_RING_LIGHT_CORNER = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "block/quantum_ring_light_corner"));
    private static final RenderMaterial TEXTURE_CABLE_GLASS = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "part/cable/glass/transparent"));
    private static final RenderMaterial TEXTURE_COVERED_CABLE = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("appliedenergistics2", "part/cable/covered/transparent"));
    private static final float DEFAULT_RENDER_MIN = 2.0f;
    private static final float DEFAULT_RENDER_MAX = 14.0f;
    private static final float CORNER_POWERED_RENDER_MIN = 3.9f;
    private static final float CORNER_POWERED_RENDER_MAX = 12.1f;
    private static final float CENTER_POWERED_RENDER_MIN = -0.01f;
    private static final float CENTER_POWERED_RENDER_MAX = 16.01f;
    private final IBakedModel baseModel;
    private final Block linkBlock;
    private final TextureAtlasSprite linkTexture;
    private final TextureAtlasSprite ringTexture;
    private final TextureAtlasSprite glassCableTexture;
    private final TextureAtlasSprite coveredCableTexture;
    private final TextureAtlasSprite lightTexture;
    private final TextureAtlasSprite lightCornerTexture;

    public QnbFormedBakedModel(IBakedModel baseModel, Function<RenderMaterial, TextureAtlasSprite> bakedTextureGetter) {
        this.baseModel = baseModel;
        this.linkTexture = bakedTextureGetter.apply(TEXTURE_LINK);
        this.ringTexture = bakedTextureGetter.apply(TEXTURE_RING);
        this.glassCableTexture = bakedTextureGetter.apply(TEXTURE_CABLE_GLASS);
        this.coveredCableTexture = bakedTextureGetter.apply(TEXTURE_COVERED_CABLE);
        this.lightTexture = bakedTextureGetter.apply(TEXTURE_RING_LIGHT);
        this.lightCornerTexture = bakedTextureGetter.apply(TEXTURE_RING_LIGHT_CORNER);
        this.linkBlock = Api.instance().definitions().blocks().quantumLink().maybeBlock().orElse(null);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
        QnbFormedState formedState = (QnbFormedState)modelData.getData(QuantumBridgeTileEntity.FORMED_STATE);
        if (formedState == null) {
            return this.baseModel.func_200117_a(state, side, rand);
        }
        if (side != null) {
            return Collections.emptyList();
        }
        return this.getQuads(formedState, state);
    }

    private List<BakedQuad> getQuads(QnbFormedState formedState, BlockState state) {
        CubeBuilder builder = new CubeBuilder();
        if (state.func_177230_c() == this.linkBlock) {
            Set<Direction> sides = formedState.getAdjacentQuantumBridges();
            this.renderCableAt(builder, 1.76f, this.glassCableTexture, 2.256f, sides);
            this.renderCableAt(builder, 3.008f, this.coveredCableTexture, 3.0f, sides);
            builder.setTexture(this.linkTexture);
            builder.addCube(2.0f, 2.0f, 2.0f, 14.0f, 14.0f, 14.0f);
        } else if (formedState.isCorner()) {
            this.renderCableAt(builder, 3.008f, this.coveredCableTexture, 0.8f, formedState.getAdjacentQuantumBridges());
            builder.setTexture(this.ringTexture);
            builder.addCube(2.0f, 2.0f, 2.0f, 14.0f, 14.0f, 14.0f);
            if (formedState.isPowered()) {
                builder.setTexture(this.lightCornerTexture);
                builder.setEmissiveMaterial(true);
                for (Direction facing : Direction.values()) {
                    float xOffset = Math.abs((float)facing.func_82601_c() * 0.01f);
                    float yOffset = Math.abs((float)facing.func_96559_d() * 0.01f);
                    float zOffset = Math.abs((float)facing.func_82599_e() * 0.01f);
                    builder.setDrawFaces(EnumSet.of(facing));
                    builder.addCube(2.0f - xOffset, 2.0f - yOffset, 2.0f - zOffset, 14.0f + xOffset, 14.0f + yOffset, 14.0f + zOffset);
                }
                builder.setEmissiveMaterial(false);
            }
        } else {
            builder.setTexture(this.ringTexture);
            builder.addCube(0.0f, 2.0f, 2.0f, 16.0f, 14.0f, 14.0f);
            builder.addCube(2.0f, 0.0f, 2.0f, 14.0f, 16.0f, 14.0f);
            builder.addCube(2.0f, 2.0f, 0.0f, 14.0f, 14.0f, 16.0f);
            if (formedState.isPowered()) {
                builder.setTexture(this.lightTexture);
                builder.setEmissiveMaterial(true);
                for (Direction facing : Direction.values()) {
                    float xOffset = Math.abs((float)facing.func_82601_c() * 0.01f);
                    float yOffset = Math.abs((float)facing.func_96559_d() * 0.01f);
                    float zOffset = Math.abs((float)facing.func_82599_e() * 0.01f);
                    builder.setDrawFaces(EnumSet.of(facing));
                    builder.addCube(-xOffset, -yOffset, -zOffset, 16.0f + xOffset, 16.0f + yOffset, 16.0f + zOffset);
                }
            }
        }
        return builder.getOutput();
    }

    private void renderCableAt(CubeBuilder builder, float thickness, TextureAtlasSprite texture, float pull, Set<Direction> connections) {
        builder.setTexture(texture);
        if (connections.contains(Direction.WEST)) {
            builder.addCube(0.0f, 8.0f - thickness, 8.0f - thickness, 8.0f - thickness - pull, 8.0f + thickness, 8.0f + thickness);
        }
        if (connections.contains(Direction.EAST)) {
            builder.addCube(8.0f + thickness + pull, 8.0f - thickness, 8.0f - thickness, 16.0f, 8.0f + thickness, 8.0f + thickness);
        }
        if (connections.contains(Direction.NORTH)) {
            builder.addCube(8.0f - thickness, 8.0f - thickness, 0.0f, 8.0f + thickness, 8.0f + thickness, 8.0f - thickness - pull);
        }
        if (connections.contains(Direction.SOUTH)) {
            builder.addCube(8.0f - thickness, 8.0f - thickness, 8.0f + thickness + pull, 8.0f + thickness, 8.0f + thickness, 16.0f);
        }
        if (connections.contains(Direction.DOWN)) {
            builder.addCube(8.0f - thickness, 0.0f, 8.0f - thickness, 8.0f + thickness, 8.0f - thickness - pull, 8.0f + thickness);
        }
        if (connections.contains(Direction.UP)) {
            builder.addCube(8.0f - thickness, 8.0f + thickness + pull, 8.0f - thickness, 8.0f + thickness, 16.0f, 8.0f + thickness);
        }
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.baseModel.func_188617_f();
    }

    public static List<RenderMaterial> getRequiredTextures() {
        return ImmutableList.of((Object)TEXTURE_LINK, (Object)TEXTURE_RING, (Object)TEXTURE_CABLE_GLASS, (Object)TEXTURE_COVERED_CABLE, (Object)TEXTURE_RING_LIGHT, (Object)TEXTURE_RING_LIGHT_CORNER);
    }
}

