/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.storage.channels.IItemStorageChannel;
import appeng.client.ActionKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.container.implementations.InterfaceTerminalContainer;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class InterfaceTerminalScreen
extends AEBaseScreen<InterfaceTerminalContainer> {
    private static final int LINES_ON_PAGE = 6;
    private final HashMap<Long, ClientDCInternalInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalInv> byName = HashMultimap.create();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private boolean refreshList = false;
    private AETextField searchField;

    public InterfaceTerminalScreen(InterfaceTerminalContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.setScrollBar(new Scrollbar().setLeft(175).setTop(18).setHeight(106));
        this.field_146999_f = 195;
        this.field_147000_g = 222;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.searchField = new AETextField(this.field_230712_o_, this.field_147003_i + 104, this.field_147009_r + 4, 65, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146189_e(true);
        this.searchField.func_212954_a(str -> this.refreshList());
        this.func_230481_d_((IGuiEventListener)this.searchField);
        this.func_231049_c__(true);
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.getGuiDisplayName(GuiText.InterfaceTerminal.text()).getString(), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.inventory.text().getString(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        int ex = this.getScrollBar().getCurrentScroll();
        ((InterfaceTerminalContainer)this.field_147002_h).field_75151_b.removeIf(slot -> slot instanceof SlotDisconnected);
        int offset = 17;
        for (int x = 0; x < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                for (int z = 0; z < inv.getInventory().getSlots(); ++z) {
                    ((InterfaceTerminalContainer)this.field_147002_h).field_75151_b.add(new SlotDisconnected(inv, z, z * 18 + 8, 1 + offset));
                }
            } else if (lineObj instanceof String) {
                String name = (String)lineObj;
                int rows = this.byName.get((Object)name).size();
                if (rows > 1) {
                    name = name + " (" + rows + ')';
                }
                while (name.length() > 2 && this.field_230712_o_.func_78256_a(name) > 155) {
                    name = name.substring(0, name.length() - 1);
                }
                this.field_230712_o_.func_238421_b_(matrixStack, name, 10.0f, (float)(6 + offset), 0x404040);
            }
            offset += 18;
        }
    }

    @Override
    public boolean func_231044_a_(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.func_231047_b_(xCoord, yCoord)) {
            this.searchField.func_146180_a("");
            return true;
        }
        return super.func_231044_a_(xCoord, yCoord, btn);
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture("guis/interfaceterminal.png");
        GuiUtils.drawTexturedModalRect((int)offsetX, (int)offsetY, (int)0, (int)0, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.func_230927_p_());
        int offset = 17;
        int ex = this.getScrollBar().getCurrentScroll();
        for (int x = 0; x < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = inv.getInventory().getSlots() * 18;
                GuiUtils.drawTexturedModalRect((int)(offsetX + 7), (int)(offsetY + offset), (int)7, (int)139, (int)width, (int)18, (float)this.func_230927_p_());
            }
            offset += 18;
        }
        if (this.searchField != null) {
            this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231042_a_(char character, int key) {
        if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
            return true;
        }
        return super.func_231042_a_(character, key);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode != 256) {
            if (AppEng.proxy.isActionKey(ActionKey.TOGGLE_FOCUS, input)) {
                this.searchField.func_146195_b(!this.searchField.func_230999_j_());
                return true;
            }
            if (this.searchField.func_230999_j_()) {
                if (keyCode == 257) {
                    this.searchField.func_146195_b(false);
                    return true;
                }
                this.searchField.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    public void postUpdate(CompoundNBT in) {
        if (in.func_74767_n("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (Object oKey : in.func_150296_c()) {
            String key = (String)oKey;
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                CompoundNBT invData = in.func_74775_l(key);
                IFormattableTextComponent un = ITextComponent.Serializer.func_240643_a_((String)invData.func_74779_i("un"));
                ClientDCInternalInv current = this.getById(id, invData.func_74763_f("sortBy"), (ITextComponent)un);
                for (int x = 0; x < current.getInventory().getSlots(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().setStackInSlot(x, ItemStack.func_199557_a((CompoundNBT)invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        String searchFilterLowerCase = this.searchField.func_146179_b().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found && !searchFilterLowerCase.isEmpty()) {
                ItemStack itemStack;
                Iterator<ItemStack> iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found || entry.getSearchName().contains(searchFilterLowerCase)) {
                this.byName.put((Object)entry.getFormattedName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.getScrollBar().setRange(0, this.lines.size() - 6, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        CompoundNBT encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return false;
        }
        ListNBT outTag = encodedValue.func_150295_c("out", 10);
        for (int i = 0; i < outTag.size(); ++i) {
            String displayName;
            ItemStack parsedItemStack = ItemStack.func_199557_a((CompoundNBT)outTag.func_150305_b(i));
            if (parsedItemStack.func_190926_b() || !(displayName = Platform.getItemDisplayName(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(parsedItemStack)).getString().toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private ClientDCInternalInv getById(long id, long sortBy, ITextComponent name) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(9, id, sortBy, name);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }
}

