/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.PowerUnits;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.implementations.NumberEntryWidget;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.implementations.LevelEmitterContainer;
import appeng.core.localization.GuiText;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class LevelEmitterScreen
extends UpgradeableScreen<LevelEmitterContainer> {
    private NumberEntryWidget level;
    private SettingToggleButton<LevelType> levelMode;
    private SettingToggleButton<YesNo> craftingMode;

    public LevelEmitterScreen(LevelEmitterContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.level = new NumberEntryWidget(this, 20, 17, 138, 62, NumberEntryType.LEVEL_ITEM_COUNT);
        this.level.setTextFieldBounds(25, 44, 75);
        this.level.addButtons(this.field_230705_e_::add, arg_0 -> ((LevelEmitterScreen)this).func_230480_a_(arg_0));
        this.level.setValue(((LevelEmitterContainer)this.field_147002_h).getReportingValue());
        this.level.setOnChange(this::saveReportingValue);
        this.level.setOnConfirm(() -> ((LevelEmitterScreen)this).func_231175_as__());
        this.func_231049_c__(true);
    }

    private void saveReportingValue() {
        this.level.getLongValue().ifPresent(((LevelEmitterContainer)this.field_147002_h)::setReportingValue);
    }

    @Override
    protected void addButtons() {
        this.levelMode = new ServerSettingToggleButton<LevelType>(this.field_147003_i - 18, this.field_147009_r + 8, Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
        this.redstoneMode = new ServerSettingToggleButton<RedstoneMode>(this.field_147003_i - 18, this.field_147009_r + 28, Settings.REDSTONE_EMITTER, RedstoneMode.LOW_SIGNAL);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(this.field_147003_i - 18, this.field_147009_r + 48, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.craftingMode = new ServerSettingToggleButton<YesNo>(this.field_147003_i - 18, this.field_147009_r + 48, Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
        this.func_230480_a_((Widget)this.levelMode);
        this.func_230480_a_((Widget)this.redstoneMode);
        this.func_230480_a_((Widget)this.craftingMode);
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        boolean notCraftingMode = this.bc.getInstalledUpgrades(Upgrades.CRAFTING) == 0;
        this.level.setActive(notCraftingMode);
        this.levelMode.field_230693_o_ = notCraftingMode;
        this.redstoneMode.field_230693_o_ = notCraftingMode;
        super.drawFG(matrixStack, offsetX, offsetY, mouseX, mouseY);
        if (this.craftingMode != null) {
            this.craftingMode.set(this.cvb.getCraftingMode());
        }
        if (this.levelMode != null) {
            LevelType currentLevelMode = ((LevelEmitterContainer)this.cvb).getLevelMode();
            this.levelMode.set(currentLevelMode);
            if (notCraftingMode && currentLevelMode == LevelType.ENERGY_LEVEL) {
                this.field_230712_o_.func_238421_b_(matrixStack, PowerUnits.AE.textComponent().getString(), 110.0f, 44.0f, 0x404040);
            }
        }
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        this.level.render(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void handleButtonVisibility() {
        this.craftingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
    }

    @Override
    protected String getBackground() {
        return "guis/lvlemitter.png";
    }

    @Override
    protected GuiText getName() {
        return GuiText.LevelEmitter;
    }
}

