/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.client.gui.widgets.ValidationIcon;
import appeng.core.AEConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NumberEntryWidget
extends AbstractGui {
    private static final ITextComponent INVALID_NUMBER = new TranslationTextComponent("gui.appliedenergistics2.validation.InvalidNumber");
    private static final String NUMBER_LESS_THAN_MIN_VALUE = "gui.appliedenergistics2.validation.NumberLessThanMinValue";
    private static final ITextComponent PLUS = new StringTextComponent("+");
    private static final ITextComponent MINUS = new StringTextComponent("-");
    private static final int TEXT_COLOR_ERROR = 16718080;
    private static final int TEXT_COLOR_NORMAL = 0xFFFFFF;
    private final AEBaseScreen<?> parent;
    private final int x;
    private final int y;
    private final ConfirmableTextField textField;
    private final NumberEntryType type;
    private List<Button> buttons;
    private long minValue;
    private ValidationIcon validationIcon;
    private Runnable onChange;
    private Runnable onConfirm;
    private boolean hideValidationIcon;

    public NumberEntryWidget(AEBaseScreen<?> parent, int x, int y, int width, int height, NumberEntryType type) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.type = type;
        FontRenderer font = parent.getMinecraft().field_71466_p;
        int inputX = parent.getGuiLeft() + x;
        int inputY = parent.getGuiTop() + y;
        font.getClass();
        this.textField = new ConfirmableTextField(font, inputX, inputY, width, 9, StringTextComponent.field_240750_d_);
        this.textField.func_146185_a(false);
        this.textField.func_146203_f(16);
        this.textField.func_146193_g(0xFFFFFF);
        this.textField.func_146189_e(true);
        this.textField.func_146195_b(true);
        parent.func_212928_a((IGuiEventListener)this.textField);
        this.textField.func_212954_a(text -> {
            this.validate();
            if (this.onChange != null) {
                this.onChange.run();
            }
        });
        this.textField.setOnConfirm(() -> {
            if (this.onConfirm != null && this.getLongValue().isPresent()) {
                this.onConfirm.run();
            }
        });
        this.validate();
    }

    public void setOnConfirm(Runnable callback) {
        this.onConfirm = callback;
    }

    public void setOnChange(Runnable callback) {
        this.onChange = callback;
    }

    public void setActive(boolean active) {
        this.textField.func_146184_c(active);
        this.buttons.forEach(b -> {
            b.field_230693_o_ = active;
        });
    }

    public void setTextFieldBounds(int x, int y, int width) {
        this.textField.field_230690_l_ = this.parent.getGuiLeft() + x;
        this.textField.field_230691_m_ = this.parent.getGuiTop() + y;
        this.textField.func_230991_b_(width);
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
        this.validate();
    }

    public void addButtons(Consumer<IGuiEventListener> addChildren, Consumer<Button> addButton) {
        int[] steps = AEConfig.instance().getNumberEntrySteps(this.type);
        int a = steps[0];
        int b = steps[1];
        int c = steps[2];
        int d = steps[3];
        int left = this.parent.getGuiLeft() + this.x;
        int top = this.parent.getGuiTop() + this.y;
        ArrayList<Button> buttons = new ArrayList<Button>(9);
        buttons.add(new Button(left, top, 22, 20, this.makeLabel(PLUS, a), btn -> this.addQty(a)));
        buttons.add(new Button(left + 28, top, 28, 20, this.makeLabel(PLUS, b), btn -> this.addQty(b)));
        buttons.add(new Button(left + 62, top, 32, 20, this.makeLabel(PLUS, c), btn -> this.addQty(c)));
        buttons.add(new Button(left + 100, top, 38, 20, this.makeLabel(PLUS, d), btn -> this.addQty(d)));
        buttons.forEach(addButton);
        addChildren.accept((IGuiEventListener)this.textField);
        buttons.add(new Button(left, top + 42, 22, 20, this.makeLabel(MINUS, a), btn -> this.addQty(-a)));
        buttons.add(new Button(left + 28, top + 42, 28, 20, this.makeLabel(MINUS, b), btn -> this.addQty(-b)));
        buttons.add(new Button(left + 62, top + 42, 32, 20, this.makeLabel(MINUS, c), btn -> this.addQty(-c)));
        buttons.add(new Button(left + 100, top + 42, 38, 20, this.makeLabel(MINUS, d), btn -> this.addQty(-d)));
        if (!this.hideValidationIcon) {
            this.validationIcon = new ValidationIcon(left + 104, top + 27);
            buttons.add(this.validationIcon);
        }
        buttons.subList(4, buttons.size()).forEach(addButton);
        this.buttons = buttons;
        this.validate();
    }

    public OptionalInt getIntValue() {
        String text = this.textField.func_146179_b().trim();
        try {
            int value = Integer.parseInt(text, 10);
            if ((long)value < this.minValue) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(value);
        }
        catch (NumberFormatException ignored) {
            return OptionalInt.empty();
        }
    }

    public OptionalLong getLongValue() {
        String text = this.textField.func_146179_b().trim();
        try {
            long value = Long.parseLong(text, 10);
            if (value < this.minValue) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(value);
        }
        catch (NumberFormatException ignored) {
            return OptionalLong.empty();
        }
    }

    public void setValue(long value) {
        this.textField.func_146180_a(String.valueOf(Math.max(this.minValue, value)));
        this.textField.func_146202_e();
        this.textField.func_146199_i(0);
        this.validate();
    }

    private void addQty(long i) {
        this.getLongValue().ifPresent(currentValue -> this.setValue(currentValue + i));
    }

    public void render(MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.textField.func_230430_a_(matrices, mouseX, mouseY, partialTicks);
    }

    private void validate() {
        ArrayList<ITextComponent> validationErrors = new ArrayList<ITextComponent>();
        String text = this.textField.func_146179_b().trim();
        try {
            long value = Long.parseLong(text, 10);
            if (value < this.minValue) {
                validationErrors.add((ITextComponent)new TranslationTextComponent(NUMBER_LESS_THAN_MIN_VALUE, new Object[]{this.minValue}));
            }
        }
        catch (NumberFormatException ignored) {
            validationErrors.add(INVALID_NUMBER);
        }
        boolean valid = validationErrors.isEmpty();
        this.textField.func_146193_g(valid ? 0xFFFFFF : 16718080);
        if (this.validationIcon != null) {
            this.validationIcon.setValid(valid);
            this.validationIcon.setTooltip(validationErrors);
        }
    }

    private ITextComponent makeLabel(ITextComponent prefix, int amount) {
        return prefix.func_230531_f_().func_240702_b_(String.valueOf(amount));
    }

    public void setHideValidationIcon(boolean hideValidationIcon) {
        this.hideValidationIcon = hideValidationIcon;
    }
}

