/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.api.config.ActionItems;
import appeng.client.gui.widgets.IconButton;
import appeng.core.localization.ButtonToolTips;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ActionButton
extends IconButton {
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\n", 16);
    private final int iconIndex;

    public ActionButton(int x, int y, ActionItems action, Consumer<ActionItems> onPress) {
        super(x, y, btn -> onPress.accept(action));
        ButtonToolTips displayValue;
        ButtonToolTips displayName;
        switch (action) {
            case WRENCH: {
                this.iconIndex = 66;
                displayName = ButtonToolTips.PartitionStorage;
                displayValue = ButtonToolTips.PartitionStorageHint;
                break;
            }
            case CLOSE: {
                this.iconIndex = 6;
                displayName = ButtonToolTips.Clear;
                displayValue = ButtonToolTips.ClearSettings;
                break;
            }
            case STASH: {
                this.iconIndex = 6;
                displayName = ButtonToolTips.Stash;
                displayValue = ButtonToolTips.StashDesc;
                break;
            }
            case ENCODE: {
                this.iconIndex = 8;
                displayName = ButtonToolTips.Encode;
                displayValue = ButtonToolTips.EncodeDescription;
                break;
            }
            case ENABLE_SUBSTITUTION: {
                this.iconIndex = 52;
                displayName = ButtonToolTips.Substitutions;
                displayValue = ButtonToolTips.SubstitutionsDescEnabled;
                break;
            }
            case DISABLE_SUBSTITUTION: {
                this.iconIndex = 55;
                displayName = ButtonToolTips.Substitutions;
                displayValue = ButtonToolTips.SubstitutionsDescDisabled;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ActionItem: " + (Object)((Object)action));
            }
        }
        this.func_238482_a_(this.buildMessage(displayName, displayValue));
    }

    @Override
    protected int getIconIndex() {
        return this.iconIndex;
    }

    private ITextComponent buildMessage(ButtonToolTips displayName, ButtonToolTips displayValue) {
        String name = displayName.text().getString();
        String value = displayValue.text().getString();
        StringBuilder sb = new StringBuilder(value = PATTERN_NEW_LINE.matcher(value).replaceAll("\n"));
        int i = sb.lastIndexOf("\n");
        if (i <= 0) {
            i = 0;
        }
        while (i + 30 < sb.length() && (i = sb.lastIndexOf(" ", i + 30)) != -1) {
            sb.replace(i, i + 1, "\n");
        }
        return new StringTextComponent(name + '\n' + sb);
    }
}

