/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.client.render.cablebus.CubeBuilder;
import appeng.tile.crafting.CraftingCubeModelData;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

abstract class CraftingCubeBakedModel
implements IDynamicBakedModel {
    private final TextureAtlasSprite ringCorner;
    private final TextureAtlasSprite ringHor;
    private final TextureAtlasSprite ringVer;

    CraftingCubeBakedModel(TextureAtlasSprite ringCorner, TextureAtlasSprite ringHor, TextureAtlasSprite ringVer) {
        this.ringCorner = ringCorner;
        this.ringHor = ringHor;
        this.ringVer = ringVer;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side == null) {
            return Collections.emptyList();
        }
        EnumSet<Direction> connections = CraftingCubeBakedModel.getConnections(extraData);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        CubeBuilder builder = new CubeBuilder(quads);
        builder.setDrawFaces(EnumSet.of(side));
        this.addRing(builder, side, connections);
        float x2 = connections.contains(Direction.EAST) ? 16.0f : 13.01f;
        float x1 = connections.contains(Direction.WEST) ? 0.0f : 2.99f;
        float y2 = connections.contains(Direction.UP) ? 16.0f : 13.01f;
        float y1 = connections.contains(Direction.DOWN) ? 0.0f : 2.99f;
        float z2 = connections.contains(Direction.SOUTH) ? 16.0f : 13.01f;
        float z1 = connections.contains(Direction.NORTH) ? 0.0f : 2.99f;
        switch (side) {
            case DOWN: 
            case UP: {
                y1 = 0.0f;
                y2 = 16.0f;
                break;
            }
            case NORTH: 
            case SOUTH: {
                z1 = 0.0f;
                z2 = 16.0f;
                break;
            }
            case WEST: 
            case EAST: {
                x1 = 0.0f;
                x2 = 16.0f;
            }
        }
        this.addInnerCube(side, state, extraData, builder, x1, y1, z1, x2, y2, z2);
        return quads;
    }

    private void addRing(CubeBuilder builder, Direction side, EnumSet<Direction> connections) {
        builder.setTexture(this.ringCorner);
        this.addCornerCap(builder, connections, side, Direction.UP, Direction.EAST, Direction.NORTH);
        this.addCornerCap(builder, connections, side, Direction.UP, Direction.EAST, Direction.SOUTH);
        this.addCornerCap(builder, connections, side, Direction.UP, Direction.WEST, Direction.NORTH);
        this.addCornerCap(builder, connections, side, Direction.UP, Direction.WEST, Direction.SOUTH);
        this.addCornerCap(builder, connections, side, Direction.DOWN, Direction.EAST, Direction.NORTH);
        this.addCornerCap(builder, connections, side, Direction.DOWN, Direction.EAST, Direction.SOUTH);
        this.addCornerCap(builder, connections, side, Direction.DOWN, Direction.WEST, Direction.NORTH);
        this.addCornerCap(builder, connections, side, Direction.DOWN, Direction.WEST, Direction.SOUTH);
        for (Direction a : Direction.values()) {
            if (a == side || a == side.func_176734_d()) continue;
            if (side.func_176740_k() != Direction.Axis.Y && (a == Direction.NORTH || a == Direction.EAST || a == Direction.WEST || a == Direction.SOUTH)) {
                builder.setTexture(this.ringVer);
            } else if (side.func_176740_k() == Direction.Axis.Y && (a == Direction.EAST || a == Direction.WEST)) {
                builder.setTexture(this.ringVer);
            } else {
                builder.setTexture(this.ringHor);
            }
            if (connections.contains(a)) continue;
            float x1 = 0.0f;
            float y1 = 0.0f;
            float z1 = 0.0f;
            float x2 = 16.0f;
            float y2 = 16.0f;
            float z2 = 16.0f;
            switch (a) {
                case DOWN: {
                    y1 = 0.0f;
                    y2 = 3.0f;
                    break;
                }
                case UP: {
                    y1 = 13.0f;
                    y2 = 16.0f;
                    break;
                }
                case WEST: {
                    x1 = 0.0f;
                    x2 = 3.0f;
                    break;
                }
                case EAST: {
                    x1 = 13.0f;
                    x2 = 16.0f;
                    break;
                }
                case NORTH: {
                    z1 = 0.0f;
                    z2 = 3.0f;
                    break;
                }
                case SOUTH: {
                    z1 = 13.0f;
                    z2 = 16.0f;
                }
            }
            Direction perpendicular = Platform.rotateAround(a, side);
            for (Direction cornerCandidate : EnumSet.of(perpendicular, perpendicular.func_176734_d())) {
                if (connections.contains(cornerCandidate)) continue;
                switch (cornerCandidate) {
                    case DOWN: {
                        y1 = 3.0f;
                        break;
                    }
                    case UP: {
                        y2 = 13.0f;
                        break;
                    }
                    case NORTH: {
                        z1 = 3.0f;
                        break;
                    }
                    case SOUTH: {
                        z2 = 13.0f;
                        break;
                    }
                    case WEST: {
                        x1 = 3.0f;
                        break;
                    }
                    case EAST: {
                        x2 = 13.0f;
                    }
                }
            }
            builder.addCube(x1, y1, z1, x2, y2, z2);
        }
    }

    private void addCornerCap(CubeBuilder builder, EnumSet<Direction> connections, Direction side, Direction down, Direction west, Direction north) {
        if (connections.contains(down) || connections.contains(west) || connections.contains(north)) {
            return;
        }
        if (side != down && side != west && side != north) {
            return;
        }
        float x1 = west == Direction.WEST ? 0 : 13;
        float y1 = down == Direction.DOWN ? 0 : 13;
        float z1 = north == Direction.NORTH ? 0 : 13;
        float x2 = west == Direction.WEST ? 3 : 16;
        float y2 = down == Direction.DOWN ? 3 : 16;
        float z2 = north == Direction.NORTH ? 3 : 16;
        builder.addCube(x1, y1, z1, x2, y2, z2);
    }

    private static EnumSet<Direction> getConnections(IModelData modelData) {
        if (!(modelData instanceof CraftingCubeModelData)) {
            return EnumSet.noneOf(Direction.class);
        }
        return ((CraftingCubeModelData)modelData).getConnections();
    }

    protected abstract void addInnerCube(Direction var1, BlockState var2, IModelData var3, CubeBuilder var4, float var5, float var6, float var7, float var8, float var9, float var10);

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.ringCorner;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

