/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.client.render.FacingToRotation;
import appeng.client.render.model.DriveBakedModel;
import appeng.client.render.tesr.CellLedRenderer;
import appeng.tile.storage.DriveTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DriveLedTileEntityRenderer
extends TileEntityRenderer<DriveTileEntity> {
    public DriveLedTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(DriveTileEntity drive, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int combinedLightIn, int combinedOverlayIn) {
        if (drive.getCellCount() != 10) {
            throw new IllegalStateException("Expected drive to have 10 slots");
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.5, 0.5);
        FacingToRotation.get(drive.getForward(), drive.getUp()).push(ms);
        ms.func_227861_a_(-0.5, -0.5, -0.5);
        IVertexBuilder buffer = buffers.getBuffer(CellLedRenderer.RENDER_LAYER);
        Vector3f slotTranslation = new Vector3f();
        for (int row = 0; row < 5; ++row) {
            for (int col = 0; col < 2; ++col) {
                ms.func_227860_a_();
                DriveBakedModel.getSlotOrigin(row, col, slotTranslation);
                ms.func_227861_a_((double)slotTranslation.func_195899_a(), (double)slotTranslation.func_195900_b(), (double)slotTranslation.func_195902_c());
                int slot = row * 2 + col;
                CellLedRenderer.renderLed(drive, slot, buffer, ms, partialTicks);
                ms.func_227865_b_();
            }
        }
        ms.func_227865_b_();
    }
}

