/*
 * Decompiled with CFR 0.152.
 */
package appeng.container;

import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.core.AELog;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;

public final class ContainerOpener {
    private static final Map<ContainerType<? extends AEBaseContainer>, Opener<?>> registry = new HashMap();

    private ContainerOpener() {
    }

    public static <T extends AEBaseContainer> void addOpener(ContainerType<T> type, Opener<T> opener) {
        registry.put(type, opener);
    }

    public static boolean openContainer(ContainerType<?> type, PlayerEntity player, ContainerLocator locator) {
        Opener<?> opener = registry.get(type);
        if (opener == null) {
            AELog.warn("Trying to open container for unknown container type {}", type);
            return false;
        }
        return opener.open(player, locator);
    }

    @FunctionalInterface
    public static interface Opener<T extends AEBaseContainer> {
        public boolean open(PlayerEntity var1, ContainerLocator var2);
    }
}

