/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.tile.misc.CondenserTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;

public class CondenserContainer
extends AEBaseContainer
implements IProgressProvider {
    public static ContainerType<CondenserContainer> TYPE;
    private static final ContainerHelper<CondenserContainer, CondenserTileEntity> helper;
    private final CondenserTileEntity condenser;
    @GuiSync(value=0)
    public long requiredEnergy = 0L;
    @GuiSync(value=1)
    public long storedPower = 0L;
    @GuiSync(value=2)
    public CondenserOutput output = CondenserOutput.TRASH;

    public CondenserContainer(int id, PlayerInventory ip, CondenserTileEntity condenser) {
        super(TYPE, id, ip, condenser, null);
        this.condenser = condenser;
        IItemHandler inv = condenser.getInternalInventory();
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.TRASH, inv, 0, 51, 52, ip));
        this.func_75146_a(new OutputSlot(inv, 1, 105, 52, -1));
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.STORAGE_COMPONENT, inv, 2, 101, 26, ip).setStackLimit(1));
        this.bindPlayerInventory(ip, 0, 115);
    }

    public static CondenserContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    @Override
    public void func_75142_b() {
        if (this.isServer()) {
            double maxStorage = this.condenser.getStorage();
            double requiredEnergy = this.condenser.getRequiredPower();
            this.requiredEnergy = requiredEnergy == 0.0 ? (long)((int)maxStorage) : (long)((int)Math.min(requiredEnergy, maxStorage));
            this.storedPower = (int)this.condenser.getStoredPower();
            this.output = (CondenserOutput)this.condenser.getConfigManager().getSetting(Settings.CONDENSER_OUTPUT);
        }
        super.func_75142_b();
    }

    @Override
    public int getCurrentProgress() {
        return (int)this.storedPower;
    }

    @Override
    public int getMaxProgress() {
        return (int)this.requiredEnergy;
    }

    public CondenserOutput getOutput() {
        return this.output;
    }

    static {
        helper = new ContainerHelper<CondenserContainer, CondenserTileEntity>(CondenserContainer::new, CondenserTileEntity.class);
    }
}

