/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.crafting.CraftingTileEntity;
import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.StringTextComponent;

public class CraftingCPUContainer
extends AEBaseContainer
implements IMEMonitorHandlerReceiver<IAEItemStack> {
    public static ContainerType<CraftingCPUContainer> TYPE;
    private static final ContainerHelper<CraftingCPUContainer, CraftingTileEntity> helper;
    private final IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final IGrid network;
    private CraftingCPUCluster monitor = null;
    @GuiSync(value=0)
    public long eta = -1L;

    private CraftingCPUContainer(int id, PlayerInventory ip, CraftingTileEntity te) {
        this(TYPE, id, ip, te);
    }

    public CraftingCPUContainer(ContainerType<?> containerType, int id, PlayerInventory ip, Object te) {
        super(containerType, id, ip, te);
        IActionHost host = (IActionHost)(te instanceof IActionHost ? te : null);
        this.network = host != null && host.getActionableNode() != null ? host.getActionableNode().getGrid() : null;
        if (te instanceof CraftingTileEntity) {
            this.setCPU(((CraftingTileEntity)te).getCluster());
        }
        if (this.getNetwork() == null && this.isServer()) {
            this.setValidContainer(false);
        }
    }

    public static CraftingCPUContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    protected void setCPU(ICraftingCPU c) {
        if (c == this.getMonitor()) {
            return;
        }
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener(this);
        }
        for (Object g : this.field_75149_d) {
            if (!(g instanceof PlayerEntity)) continue;
            NetworkHandler.instance().sendTo(new ConfigValuePacket("CraftingStatus", "Clear"), (ServerPlayerEntity)g);
        }
        if (c instanceof CraftingCPUCluster) {
            this.monitor = (CraftingCPUCluster)c;
            this.list.resetStatus();
            this.getMonitor().getListOfItem(this.list, CraftingItemList.ALL);
            this.getMonitor().addListener(this, (Object)null);
            this.setEstimatedTime(0L);
        } else {
            this.monitor = null;
            this.setEstimatedTime(-1L);
        }
    }

    public void cancelCrafting() {
        if (this.getMonitor() != null) {
            this.getMonitor().cancel();
        }
        this.setEstimatedTime(-1L);
    }

    public void func_82847_b(IContainerListener c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.getMonitor() != null) {
            this.getMonitor().removeListener(this);
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener(this);
        }
    }

    @Override
    public void func_75142_b() {
        if (this.isServer() && this.getMonitor() != null && !this.list.isEmpty()) {
            try {
                if (this.getEstimatedTime() >= 0L) {
                    long elapsedTime = this.getMonitor().getElapsedTime();
                    double remainingItems = this.getMonitor().getRemainingItemCount();
                    double startItems = this.getMonitor().getStartItemCount();
                    long eta = (long)((double)elapsedTime / Math.max(1.0, startItems - remainingItems) * remainingItems);
                    this.setEstimatedTime(eta);
                }
                MEInventoryUpdatePacket a = new MEInventoryUpdatePacket(0);
                MEInventoryUpdatePacket b = new MEInventoryUpdatePacket(1);
                MEInventoryUpdatePacket c = new MEInventoryUpdatePacket(2);
                for (IAEItemStack out : this.list) {
                    a.appendItem(this.getMonitor().getItemStack(out, CraftingItemList.STORAGE));
                    b.appendItem(this.getMonitor().getItemStack(out, CraftingItemList.ACTIVE));
                    c.appendItem(this.getMonitor().getItemStack(out, CraftingItemList.PENDING));
                }
                this.list.resetStatus();
                for (IAEItemStack g : this.field_75149_d) {
                    if (!(g instanceof PlayerEntity)) continue;
                    if (!a.isEmpty()) {
                        NetworkHandler.instance().sendTo(a, (ServerPlayerEntity)g);
                    }
                    if (!b.isEmpty()) {
                        NetworkHandler.instance().sendTo(b, (ServerPlayerEntity)g);
                    }
                    if (c.isEmpty()) continue;
                    NetworkHandler.instance().sendTo(c, (ServerPlayerEntity)g);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.func_75142_b();
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource actionSource) {
        for (IAEItemStack is : change) {
            is = is.copy();
            is.setStackSize(1L);
            this.list.add(is);
        }
    }

    @Override
    public void onListUpdate() {
    }

    public long getEstimatedTime() {
        return this.eta;
    }

    private void setEstimatedTime(long eta) {
        this.eta = eta;
    }

    CraftingCPUCluster getMonitor() {
        return this.monitor;
    }

    IGrid getNetwork() {
        return this.network;
    }

    static {
        helper = new ContainerHelper<CraftingCPUContainer, CraftingTileEntity>(CraftingCPUContainer::new, CraftingTileEntity.class, SecurityPermissions.CRAFT).withContainerTitle(craftingTileEntity -> {
            CraftingCPUCluster cluster = craftingTileEntity.getCluster();
            if (cluster != null && cluster.getName() != null) {
                return cluster.getName();
            }
            return StringTextComponent.field_240750_d_;
        });
    }
}

