/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerHelper;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.items.contents.QuartzKnifeObj;
import appeng.tile.inventory.AppEngInternalInventory;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class QuartzKnifeContainer
extends AEBaseContainer {
    public static ContainerType<QuartzKnifeContainer> TYPE;
    private static final ContainerHelper<QuartzKnifeContainer, QuartzKnifeObj> helper;
    private final QuartzKnifeObj toolInv;
    private final IItemHandler inSlot = new AppEngInternalInventory(null, 1, 1);
    private String myName = "";

    public static QuartzKnifeContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public QuartzKnifeContainer(int id, PlayerInventory ip, QuartzKnifeObj te) {
        super(TYPE, id, ip, null, null);
        this.toolInv = te;
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.METAL_INGOTS, this.inSlot, 0, 94, 44, ip));
        this.func_75146_a(new QuartzKniveSlot(this.inSlot, 0, 134, 44, -1));
        this.lockPlayerInventorySlot(ip.field_70461_c);
        this.bindPlayerInventory(ip, 0, 102);
    }

    public void setName(String value) {
        this.myName = value;
    }

    @Override
    public void func_75142_b() {
        ItemStack currentItem = this.getPlayerInv().func_70448_g();
        if (currentItem != this.toolInv.getItemStack()) {
            if (!currentItem.func_190926_b()) {
                if (ItemStack.func_179545_c((ItemStack)this.toolInv.getItemStack(), (ItemStack)currentItem)) {
                    this.getPlayerInv().func_70299_a(this.getPlayerInv().field_70461_c, this.toolInv.getItemStack());
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.setValidContainer(false);
            }
        }
        super.func_75142_b();
    }

    public void func_75134_a(PlayerEntity par1PlayerEntity) {
        if (this.inSlot.getStackInSlot(0) != null) {
            par1PlayerEntity.func_71019_a(this.inSlot.getStackInSlot(0), false);
        }
    }

    static {
        helper = new ContainerHelper<QuartzKnifeContainer, QuartzKnifeObj>(QuartzKnifeContainer::new, QuartzKnifeObj.class);
    }

    private class QuartzKniveSlot
    extends OutputSlot {
        QuartzKniveSlot(IItemHandler inv, int invSlot, int x, int y, int iconIdx) {
            super(inv, invSlot, x, y, iconIdx);
        }

        @Override
        public ItemStack func_75211_c() {
            IItemHandler baseInv = this.getItemHandler();
            ItemStack input = baseInv.getStackInSlot(0);
            if (input == ItemStack.field_190927_a) {
                return ItemStack.field_190927_a;
            }
            if (RestrictedInputSlot.isMetalIngot(input) && QuartzKnifeContainer.this.myName.length() > 0) {
                return Api.instance().definitions().materials().namePress().maybeStack(1).map(namePressStack -> {
                    CompoundNBT compound = namePressStack.func_196082_o();
                    compound.func_74778_a("InscribeName", QuartzKnifeContainer.this.myName);
                    return namePressStack;
                }).orElse(ItemStack.field_190927_a);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        @Nonnull
        public ItemStack func_75209_a(int amount) {
            ItemStack ret = this.func_75211_c();
            if (!ret.func_190926_b()) {
                this.makePlate();
            }
            return ret;
        }

        @Override
        public void func_75215_d(ItemStack stack) {
            if (stack.func_190926_b()) {
                this.makePlate();
            }
        }

        private void makePlate() {
            if (QuartzKnifeContainer.this.isServer() && !this.getItemHandler().extractItem(0, 1, false).func_190926_b()) {
                ItemStack item = QuartzKnifeContainer.this.toolInv.getItemStack();
                ItemStack before = item.func_77946_l();
                item.func_222118_a(1, (LivingEntity)QuartzKnifeContainer.this.getPlayerInv().field_70458_d, p -> {
                    QuartzKnifeContainer.this.getPlayerInv().func_70299_a(QuartzKnifeContainer.this.getPlayerInv().field_70461_c, ItemStack.field_190927_a);
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(QuartzKnifeContainer.this.getPlayerInv().field_70458_d, before, null));
                });
                QuartzKnifeContainer.this.func_75142_b();
            }
        }
    }
}

