/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.parts.IPart;
import appeng.api.util.IConfigManager;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.slot.FakeTypeOnlySlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalFakeSlot;
import appeng.container.slot.OptionalTypeOnlyFakeSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.items.contents.NetworkToolViewer;
import appeng.items.tools.NetworkToolItem;
import appeng.parts.automation.ExportBusPart;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class UpgradeableContainer
extends AEBaseContainer
implements IOptionalSlotHost {
    public static ContainerType<UpgradeableContainer> TYPE;
    private static final ContainerHelper<UpgradeableContainer, IUpgradeableHost> helper;
    private final IUpgradeableHost upgradeable;
    @GuiSync(value=0)
    public RedstoneMode rsMode = RedstoneMode.IGNORE;
    @GuiSync(value=1)
    public FuzzyMode fzMode = FuzzyMode.IGNORE_ALL;
    @GuiSync(value=5)
    public YesNo cMode = YesNo.NO;
    @GuiSync(value=6)
    public SchedulingMode schedulingMode = SchedulingMode.DEFAULT;
    private int tbSlot;
    private NetworkToolViewer tbInventory;

    public static UpgradeableContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public UpgradeableContainer(int id, PlayerInventory ip, IUpgradeableHost te) {
        this(TYPE, id, ip, te);
    }

    public UpgradeableContainer(ContainerType<?> containerType, int id, PlayerInventory ip, IUpgradeableHost te) {
        super(containerType, id, ip, (TileEntity)(te instanceof TileEntity ? te : null), (IPart)((Object)(te instanceof IPart ? te : null)));
        this.upgradeable = te;
        World w = null;
        int xCoord = 0;
        int yCoord = 0;
        int zCoord = 0;
        if (te instanceof TileEntity) {
            TileEntity myTile = (TileEntity)te;
            w = myTile.func_145831_w();
            xCoord = myTile.func_174877_v().func_177958_n();
            yCoord = myTile.func_174877_v().func_177956_o();
            zCoord = myTile.func_174877_v().func_177952_p();
        }
        if (te instanceof IPart) {
            TileEntity mk = te.getTile();
            w = mk.func_145831_w();
            xCoord = mk.func_174877_v().func_177958_n();
            yCoord = mk.func_174877_v().func_177956_o();
            zCoord = mk.func_174877_v().func_177952_p();
        }
        PlayerInventory pi = this.getPlayerInv();
        for (int x = 0; x < pi.func_70302_i_(); ++x) {
            ItemStack pii = pi.func_70301_a(x);
            if (pii.func_190926_b() || !(pii.func_77973_b() instanceof NetworkToolItem)) continue;
            this.lockPlayerInventorySlot(x);
            this.tbSlot = x;
            this.tbInventory = (NetworkToolViewer)((IGuiItem)pii.func_77973_b()).getGuiObject(pii, x, w, new BlockPos(xCoord, yCoord, zCoord));
            break;
        }
        if (this.hasToolbox()) {
            for (int v = 0; v < 3; ++v) {
                for (int u = 0; u < 3; ++u) {
                    this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, this.tbInventory.getInternalInventory(), u + v * 3, 186 + u * 18, this.getHeight() - 82 + v * 18, this.getPlayerInventory()).setPlayerSide());
                }
            }
        }
        this.setupConfig();
        this.bindPlayerInventory(ip, 0, this.getHeight() - 82);
    }

    public boolean hasToolbox() {
        return this.tbInventory != null;
    }

    protected int getHeight() {
        return 184;
    }

    protected void setupConfig() {
        this.setupUpgrades();
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        int y = 40;
        int x = 80;
        this.func_75146_a(new FakeTypeOnlySlot(inv, 0, 80, 40));
        if (this.supportCapacity()) {
            this.func_75146_a(new OptionalTypeOnlyFakeSlot(inv, this, 1, 80, 40, -1, 0, 1));
            this.func_75146_a(new OptionalTypeOnlyFakeSlot(inv, this, 2, 80, 40, 1, 0, 1));
            this.func_75146_a(new OptionalTypeOnlyFakeSlot(inv, this, 3, 80, 40, 0, -1, 1));
            this.func_75146_a(new OptionalTypeOnlyFakeSlot(inv, this, 4, 80, 40, 0, 1, 1));
            this.func_75146_a(new OptionalTypeOnlyFakeSlot(inv, this, 5, 80, 40, -1, -1, 2));
            this.func_75146_a(new OptionalTypeOnlyFakeSlot(inv, this, 6, 80, 40, 1, -1, 2));
            this.func_75146_a(new OptionalTypeOnlyFakeSlot(inv, this, 7, 80, 40, -1, 1, 2));
            this.func_75146_a(new OptionalTypeOnlyFakeSlot(inv, this, 8, 80, 40, 1, 1, 2));
        }
    }

    protected void setupUpgrades() {
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        if (this.availableUpgrades() > 0) {
            this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getPlayerInventory()).setNotDraggable());
        }
        if (this.availableUpgrades() > 1) {
            this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getPlayerInventory()).setNotDraggable());
        }
        if (this.availableUpgrades() > 2) {
            this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getPlayerInventory()).setNotDraggable());
        }
        if (this.availableUpgrades() > 3) {
            this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getPlayerInventory()).setNotDraggable());
        }
    }

    protected boolean supportCapacity() {
        return true;
    }

    public int availableUpgrades() {
        return 4;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            IConfigManager cm = this.getUpgradeable().getConfigManager();
            this.loadSettingsFromHost(cm);
        }
        this.checkToolbox();
        for (Object o : this.field_75151_b) {
            OptionalFakeSlot fs;
            if (!(o instanceof OptionalFakeSlot) || (fs = (OptionalFakeSlot)o).isSlotEnabled() || fs.getDisplayStack().func_190926_b()) continue;
            fs.clearStack();
        }
        this.standardDetectAndSendChanges();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
        this.setRedStoneMode((RedstoneMode)cm.getSetting(Settings.REDSTONE_CONTROLLED));
        if (this.getUpgradeable() instanceof ExportBusPart) {
            this.setCraftingMode((YesNo)cm.getSetting(Settings.CRAFT_ONLY));
            this.setSchedulingMode((SchedulingMode)cm.getSetting(Settings.SCHEDULING_MODE));
        }
    }

    protected void checkToolbox() {
        ItemStack currentItem;
        if (this.hasToolbox() && (currentItem = this.getPlayerInv().func_70301_a(this.tbSlot)) != this.tbInventory.getItemStack()) {
            if (!currentItem.func_190926_b()) {
                if (ItemStack.func_179545_c((ItemStack)this.tbInventory.getItemStack(), (ItemStack)currentItem)) {
                    this.getPlayerInv().func_70299_a(this.tbSlot, this.tbInventory.getItemStack());
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.setValidContainer(false);
            }
        }
    }

    protected void standardDetectAndSendChanges() {
        super.func_75142_b();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        if (idx == 1 && upgrades > 0) {
            return true;
        }
        return idx == 2 && upgrades > 1;
    }

    public FuzzyMode getFuzzyMode() {
        return this.fzMode;
    }

    public void setFuzzyMode(FuzzyMode fzMode) {
        this.fzMode = fzMode;
    }

    public YesNo getCraftingMode() {
        return this.cMode;
    }

    public void setCraftingMode(YesNo cMode) {
        this.cMode = cMode;
    }

    public RedstoneMode getRedStoneMode() {
        return this.rsMode;
    }

    public void setRedStoneMode(RedstoneMode rsMode) {
        this.rsMode = rsMode;
    }

    public SchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    private void setSchedulingMode(SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    protected IUpgradeableHost getUpgradeable() {
        return this.upgradeable;
    }

    static {
        helper = new ContainerHelper<UpgradeableContainer, IUpgradeableHost>(UpgradeableContainer::new, IUpgradeableHost.class, SecurityPermissions.BUILD);
    }
}

