/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IBlockDefinition;
import appeng.api.features.AEFeature;
import appeng.core.features.ItemDefinition;
import com.google.common.base.Preconditions;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class BlockDefinition
extends ItemDefinition
implements IBlockDefinition {
    private final Block block;
    private final BlockItem blockItem;

    public BlockDefinition(String registryName, Block block, BlockItem item, Set<AEFeature> features) {
        super(registryName, (Item)item, features);
        this.block = block;
        this.blockItem = item;
    }

    @Override
    public final Block block() {
        return this.block;
    }

    @Override
    public BlockItem blockItem() {
        return this.blockItem;
    }

    @Override
    public final ItemStack stack(int stackSize) {
        Preconditions.checkArgument((stackSize > 0 ? 1 : 0) != 0);
        return new ItemStack((IItemProvider)this.block, stackSize);
    }

    @Override
    public final boolean isSameAs(IBlockReader world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this.block;
    }
}

